/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventChannel;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.chooser.BestChannelUtil;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.vector.EventVectorSubsetter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class BestChannelAtStation
implements EventChannelSubsetter,
EventVectorSubsetter {
    BestChannelUtil bestChanUtil = new BestChannelUtil();

    public BestChannelAtStation(Element config) {
        if (DOMHelper.hasElement((Element)config, (String)"siteCodeHeuristic")) {
            String siteCodeHeuristic = SodUtil.getNestedText(SodUtil.getElement(config, "siteCodeHeuristic"));
            this.bestChanUtil.setSiteCodeHeuristic(siteCodeHeuristic.split(","));
        }
        if (DOMHelper.hasElement((Element)config, (String)"gainCodeHeuristic")) {
            String gainCodeHeuristic = SodUtil.getNestedText(SodUtil.getElement(config, "gainCodeHeuristic"));
            this.bestChanUtil.setGainCodeHeuristic(gainCodeHeuristic.split(","));
        }
        if (DOMHelper.hasElement((Element)config, (String)"bandCodeHeuristic")) {
            String bandCodeHeuristic = SodUtil.getNestedText(SodUtil.getElement(config, "bandCodeHeuristic"));
            this.bestChanUtil.setBandCodeHeuristic(bandCodeHeuristic.split(","));
        }
        if (DOMHelper.hasElement((Element)config, (String)"orientationCodeHeuristic")) {
            String orientationCodeHeuristic = SodUtil.getNestedText(SodUtil.getElement(config, "orientationCodeHeuristic"));
            this.bestChanUtil.setOrientationCodeHeuristic(orientationCodeHeuristic.split(","));
        }
    }

    @Override
    public StringTree accept(CacheEvent event, ChannelImpl channel, CookieJar cookieJar) throws Exception {
        ChannelImpl bestChan;
        List<ChannelImpl> staChans = Start.getNetworkArm().getSuccessfulChannels((StationImpl)channel.getStation());
        List allChannels = BestChannelUtil.pruneChannels(staChans, (MicroSecondDate)event.getOrigin().getTime());
        ChannelImpl[] bestChannels = this.bestChanUtil.getBestMotionVector(allChannels);
        if (bestChannels == null && (bestChan = this.bestChanUtil.getBestChannel(allChannels)) != null) {
            bestChannels = new ChannelImpl[]{bestChan};
        }
        if (bestChannels == null) {
            return new Fail((Object)this, "No best channels");
        }
        for (int i = 0; i < bestChannels.length; ++i) {
            if (!ChannelIdUtil.areEqual((ChannelImpl)channel, (ChannelImpl)bestChannels[i])) continue;
            return new Pass(this);
        }
        return new Fail(this);
    }

    @Override
    public StringTree accept(CacheEvent event, ChannelGroup channelGroup, CookieJar cookieJar) throws Exception {
        List<ChannelGroup> staChans = Start.getNetworkArm().getSuccessfulChannelGroups(channelGroup.getStation());
        List<ChannelImpl> allChannels = new ArrayList(staChans.size() * 3);
        for (ChannelGroup cg : staChans) {
            ChannelImpl[] cgChans = cg.getChannels();
            allChannels.add(cgChans[0]);
            allChannels.add(cgChans[1]);
            allChannels.add(cgChans[2]);
        }
        ChannelImpl[] bestChannels = this.bestChanUtil.getBestMotionVector(allChannels = BestChannelUtil.pruneChannels(allChannels, (MicroSecondDate)event.getOrigin().getTime()));
        if (bestChannels == null) {
            return new Fail((Object)this, "No best channel group");
        }
        ChannelGroup best = new ChannelGroup(ChannelImpl.implize((Channel[])bestChannels));
        if (best.areEqual(channelGroup)) {
            return new Pass(this);
        }
        return new Fail(this);
    }
}

