/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.SeismicHardware;
import edu.iris.Fissures.IfNetwork.Sensor;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.subsetter.channel.InstrumentationSubsetter;

public abstract class SensorSubsetter
extends InstrumentationSubsetter {
    @Override
    protected SeismicHardware getSeismicHardware(Instrumentation inst) {
        return inst.the_sensor;
    }

    protected boolean acceptNominalHighFreq(ChannelImpl channel, NetworkSource network, float nominalHighFreq) {
        try {
            return ((Sensor)this.getSeismicHardware((ChannelImpl)channel, (NetworkSource)network)).nominal_high_freq == nominalHighFreq;
        }
        catch (ChannelNotFound ex) {
            SensorSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            SensorSubsetter.handle(ex);
            return false;
        }
        catch (SodSourceException ex) {
            SensorSubsetter.handle(ex);
            return false;
        }
    }

    protected boolean acceptNominalLowFreq(ChannelImpl channel, NetworkSource network, float nominalLowFreq) {
        try {
            return ((Sensor)this.getSeismicHardware((ChannelImpl)channel, (NetworkSource)network)).nominal_low_freq == nominalLowFreq;
        }
        catch (ChannelNotFound ex) {
            SensorSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            SensorSubsetter.handle(ex);
            return false;
        }
        catch (SodSourceException ex) {
            SensorSubsetter.handle(ex);
            return false;
        }
    }
}

