/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.TemplateFileLoader;
import edu.sc.seis.sod.status.eventArm.EventStatusTemplate;
import edu.sc.seis.sod.status.waveformArm.WaveformEventGroup;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WaveformStatusTemplate
extends FileWritingTemplate
implements WaveformMonitor {
    private List eventTemplates = new ArrayList();

    public WaveformStatusTemplate(Element el) throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        super(WaveformStatusTemplate.extractConstructorBaseDirArg(el), WaveformStatusTemplate.extractConstructorFilenameArg(el));
        Element config = TemplateFileLoader.getTemplate(SodUtil.getElement(el, "config"));
        config.removeChild(SodUtil.getElement(config, "filename"));
        this.parse(config);
    }

    private static String extractConstructorFilenameArg(Element el) throws IOException, SAXException, ParserConfigurationException, DOMException {
        String fileDir = WaveformStatusTemplate.extractConstructorBaseDirArg(el);
        Element eventConfigEl = SodUtil.getElement(el, "config");
        Element templateConfig = TemplateFileLoader.getTemplate(eventConfigEl);
        Element fileNameElement = SodUtil.getElement(templateConfig, "filename");
        String filename = fileNameElement.getFirstChild().getNodeValue();
        return filename;
    }

    private static String extractConstructorBaseDirArg(Element el) {
        String fileDir = null;
        try {
            fileDir = SodUtil.getElement(el, "fileDir").getFirstChild().getNodeValue();
        }
        catch (NullPointerException e) {
            LoggerFactory.getLogger(EventStatusTemplate.class).debug("fileDir element is null! using default");
        }
        if (fileDir == null) {
            fileDir = FileWritingTemplate.getBaseDirectoryName();
        }
        return fileDir;
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("events")) {
            WaveformEventGroup ect = new WaveformEventGroup(el);
            this.eventTemplates.add(ect);
            return ect;
        }
        return super.getTemplate(tag, el);
    }

    @Override
    public void update(EventChannelPair ecp) {
        Iterator it = this.eventTemplates.iterator();
        while (it.hasNext()) {
            ((WaveformMonitor)it.next()).update(ecp);
        }
        this.write();
    }

    @Override
    public void update(EventVectorPair ecp) {
        Iterator it = this.eventTemplates.iterator();
        while (it.hasNext()) {
            ((WaveformMonitor)it.next()).update(ecp);
        }
        this.write();
    }

    @Override
    public void update(EventStationPair ecp) {
        Iterator it = this.eventTemplates.iterator();
        while (it.hasNext()) {
            ((WaveformMonitor)it.next()).update(ecp);
        }
        this.write();
    }

    @Override
    public void update(EventNetworkPair ecp) {
        Iterator it = this.eventTemplates.iterator();
        while (it.hasNext()) {
            ((WaveformMonitor)it.next()).update(ecp);
        }
        this.write();
    }
}

