/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import org.apache.velocity.context.AbstractContext;
import org.apache.velocity.context.Context;

public class StationWaveformContext
extends AbstractContext {
    protected StationImpl stationId;
    SodDB jdbcECS;
    public static final String ALL_EVENTS = "station_events";
    public static final String SUCCESS_EVENTS_KEY = "successful_station_events";
    public static final String SUCCESS_ECPS_KEY = "successful_event_channels";
    public static final String SUCCESS_ECGROUP_KEY = "successful_event_channel_groups";

    public StationWaveformContext(StationImpl station) throws SQLException {
        this.stationId = station;
        this.jdbcECS = SodDB.getSingleton();
    }

    public StationWaveformContext(Context context, StationImpl station) throws SQLException {
        super(context);
        this.stationId = station;
        this.jdbcECS = SodDB.getSingleton();
    }

    public Object internalGet(String key) {
        if (key.equals(ALL_EVENTS)) {
            List<CacheEvent> ecps = this.jdbcECS.getEventsForStation(this.stationId);
            HashSet<CacheEvent> out = new HashSet<CacheEvent>();
            out.addAll(ecps);
            return out;
        }
        if (key.equals(SUCCESS_EVENTS_KEY)) {
            List<StatefulEvent> ecps = this.jdbcECS.getSuccessfulEventsForStation(this.stationId);
            HashSet<StatefulEvent> out = new HashSet<StatefulEvent>();
            out.addAll(ecps);
            return out;
        }
        throw new RuntimeException("can't get for key=" + key);
    }

    public boolean internalContainsKey(Object key) {
        if (key.equals(ALL_EVENTS) || key.equals(SUCCESS_EVENTS_KEY) || key.equals(SUCCESS_ECPS_KEY) || key.equals(SUCCESS_ECGROUP_KEY)) {
            return true;
        }
        throw new RuntimeException("can't get for key=" + key);
    }

    public Object[] internalGetKeys() {
        return new String[]{ALL_EVENTS};
    }

    public Object internalRemove(Object key) {
        throw new RuntimeException("Read only context, operation remove not permitted: key=" + key);
    }

    public Object internalPut(String key, Object p2) {
        throw new RuntimeException("Read only context, operation put not permitted: key=" + key);
    }
}

