/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.networkArm;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.NetworkFormatter;
import edu.sc.seis.sod.status.StationGroupTemplate;
import edu.sc.seis.sod.status.networkArm.NetworkInfoTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class StationsInNetworkTemplate
extends NetworkInfoTemplate {
    private NetworkAttr network;
    private List stationListeners = new ArrayList();
    private Logger logger = LoggerFactory.getLogger(StationsInNetworkTemplate.class);

    public StationsInNetworkTemplate(Element el, String baseDir, String outputLocation, NetworkAttr net) throws IOException, ConfigurationException {
        super(baseDir, outputLocation);
        this.network = net;
        this.parse(el);
        this.write();
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("stations")) {
            StationGroupTemplate sgt = new StationGroupTemplate(el);
            this.stationListeners.add(sgt);
            return sgt;
        }
        if (tag.equals("network")) {
            return new MyNetworkTemplate(el);
        }
        return super.getTemplate(tag, el);
    }

    public void change(Station station, Status status) {
        Iterator it = this.stationListeners.iterator();
        while (it.hasNext()) {
            ((StationGroupTemplate)it.next()).change(station, status);
        }
        this.write();
    }

    public NetworkAttr getNetwork() {
        return this.network;
    }

    private class MyNetworkTemplate
    implements GenericTemplate {
        NetworkFormatter formatter;

        public MyNetworkTemplate(Element el) throws ConfigurationException {
            this.formatter = new NetworkFormatter(el);
        }

        @Override
        public String getResult() {
            return this.formatter.getResult(StationsInNetworkTemplate.this.network);
        }
    }
}

