/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.eventArm;

import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.EQDataEvent;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.colorizer.event.EventColorizer;
import edu.sc.seis.fissuresUtil.map.colorizer.event.FreshnessEventColorizer;
import edu.sc.seis.fissuresUtil.map.layers.EventLayer;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.MapPool;
import edu.sc.seis.sod.status.OutputScheduler;
import edu.sc.seis.sod.status.eventArm.EventMonitor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class MapEventStatus
implements SodElement,
EventMonitor,
Runnable {
    private String fileLoc;
    private static MapPool pool = MapPool.getDefaultPool();
    private static Logger logger = LoggerFactory.getLogger(MapEventStatus.class);

    public MapEventStatus(Element element) {
        this(MapEventStatus.getLocation(element));
    }

    public MapEventStatus(String location) {
        this.fileLoc = location;
        this.run();
    }

    public static String getLocation(Element el) {
        return FileWritingTemplate.getBaseDirectoryName() + '/' + el.getAttribute("xlink:href");
    }

    @Override
    public void change(CacheEvent event, Status status) {
        OutputScheduler.getDefault().schedule(this);
    }

    public String getLocation() {
        return this.fileLoc;
    }

    @Override
    public void run() {
        OpenMap map = pool.getMap((EventColorizer)new FreshnessEventColorizer());
        try {
            EventLayer el = map.getEventLayer();
            el.eventDataChanged(new EQDataEvent(StatefulEventDB.getSingleton().getAll()));
            map.writeMapToPNG(this.fileLoc);
        }
        catch (IOException e) {
            throw new RuntimeException("Trouble writing map", e);
        }
        finally {
            pool.returnMap(map);
        }
    }

    @Override
    public void setArmStatus(String status) {
    }
}

