/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.ArmListener;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.NetworkArm;
import edu.sc.seis.sod.PeriodicCheckpointer;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.SodDB;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputScheduler
extends Thread
implements ArmListener {
    private static final TimeInterval ACTION_INTERVAL = new TimeInterval(10.0, UnitImpl.SECOND);
    private static final long ACTION_INTERVAL_MILLIS = (long)ACTION_INTERVAL.convertTo(UnitImpl.MILLISECOND).get_value();
    private static OutputScheduler DEFAULT = null;
    private Set arms = Collections.synchronizedSet(new HashSet());
    private Set runnables = Collections.synchronizedSet(new HashSet());
    private Set onExitRunnables = Collections.synchronizedSet(new HashSet());
    private static final Logger logger = LoggerFactory.getLogger(OutputScheduler.class);

    private OutputScheduler() {
        super("OutputScheduler");
        Start.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void starting(Arm arm) {
        Set set = this.arms;
        synchronized (set) {
            this.arms.add(arm);
            if (this.arms.size() == 1) {
                OutputScheduler outputScheduler = this;
                synchronized (outputScheduler) {
                    this.notify();
                }
            }
        }
        if (arm instanceof NetworkArm) {
            ((NetworkArm)arm).add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(Arm arm) {
        OutputScheduler outputScheduler = this;
        synchronized (outputScheduler) {
            this.notifyAll();
        }
    }

    @Override
    public void started() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable a) {
        Set set = this.runnables;
        synchronized (set) {
            this.runnables.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleForExit(Runnable a) {
        Set set = this.onExitRunnables;
        synchronized (set) {
            this.onExitRunnables.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputScheduler outputScheduler;
        try {
            outputScheduler = this;
            synchronized (outputScheduler) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (true) {
            this.runAll(this.runnables);
            if (Start.isArmFailure() || !this.anyArmsActive()) {
                this.runAll(this.runnables);
                this.runAll(this.onExitRunnables);
                if (ConnMgr.getDB_TYPE().equals("HSQL") && Start.getRunProps().checkpointPeriodically()) {
                    new PeriodicCheckpointer().run();
                }
                logger.debug("Output Scheduler done.");
                logger.info("Lo!  I am weary of my wisdom, like the bee that hath gathered too much\nhoney; I need hands outstretched to take it.");
                String lcOSName = System.getProperty("os.name").toLowerCase();
                boolean MAC_OS_X = lcOSName.startsWith("mac os x");
                if (MAC_OS_X && !Start.getRunProps().isStatusWebKeepAlive()) {
                    try {
                        Connection conn = ConnMgr.createConnection();
                        conn.createStatement().execute("shutdown");
                        conn.close();
                    }
                    catch (SQLException e) {
                        GlobalExceptionHandler.handle((Throwable)e);
                    }
                    logger.info("Using System.exit(0) only on the mac due to AWT thread not exiting.");
                    System.err.println("Using System.exit(0) only on the mac due to AWT thread not exiting.");
                    System.exit(0);
                }
                return;
            }
            try {
                outputScheduler = this;
                synchronized (outputScheduler) {
                    if (!Start.isArmFailure()) {
                        this.wait(ACTION_INTERVAL_MILLIS);
                    }
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAll(Set toRun) {
        Runnable[] currentRunnables = new Runnable[]{};
        Set set = toRun;
        synchronized (set) {
            currentRunnables = toRun.toArray(currentRunnables);
            toRun.clear();
        }
        for (int i = 0; i < currentRunnables.length && !Start.isArmFailure(); ++i) {
            try {
                currentRunnables[i].run();
                continue;
            }
            catch (Throwable t) {
                GlobalExceptionHandler.handle((Throwable)t);
            }
        }
        SodDB.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean anyArmsActive() {
        Arm[] curArms = new Arm[]{};
        Set set = this.arms;
        synchronized (set) {
            curArms = this.arms.toArray(curArms);
        }
        boolean active = false;
        for (int i = 0; i < curArms.length; ++i) {
            if (!curArms[i].isActive()) continue;
            active = true;
            break;
        }
        return active;
    }

    public static synchronized OutputScheduler getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OutputScheduler();
            DEFAULT.start();
        }
        return DEFAULT;
    }
}

