/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.AllTextTemplate;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.NetworkFormatter;
import edu.sc.seis.sod.status.NetworkTemplate;
import edu.sc.seis.sod.status.Template;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NetworkGroupTemplate
extends Template
implements GenericTemplate {
    Map statusMap = new HashMap();
    Map networkMap = new HashMap();
    LinkedList useStanding = new LinkedList();
    LinkedList notUseStanding = new LinkedList();

    public NetworkGroupTemplate(Element el) throws ConfigurationException {
        this.parse(el);
    }

    @Override
    protected Object getTemplate(String tag, Element element) throws ConfigurationException {
        if (tag.equals("network")) {
            return new NetworkFormatter(element, this);
        }
        if (tag.equals("statusFilter")) {
            NodeList nl = element.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!(nl.item(i) instanceof Element)) continue;
                Element child = (Element)nl.item(i);
                String name = SodUtil.getNestedText(child);
                try {
                    if (child.getTagName().equals("status")) {
                        this.useStanding.add(Standing.getForName(name));
                        continue;
                    }
                    if (!child.getTagName().equals("notStatus")) continue;
                    this.notUseStanding.add(Standing.getForName(name));
                    continue;
                }
                catch (NoSuchFieldException e) {
                    String msg = "status tag " + name + " is not a valid Standing, please use one of: ";
                    Field[] fields = Standing.class.getFields();
                    for (int fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
                        if (!fields[fieldIndex].getType().equals(Standing.class)) continue;
                        msg = msg + (fieldIndex == 0 ? " " : ", ") + fields[fieldIndex].getName();
                    }
                    throw new ConfigurationException(msg);
                }
            }
            return new AllTextTemplate("");
        }
        return this.getCommonTemplate(tag, element);
    }

    @Override
    protected Object textTemplate(final String text) {
        return new NetworkTemplate(){

            @Override
            public String getResult(NetworkAttr net) {
                return text;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResult() {
        StringBuffer buf = new StringBuffer();
        Map map = this.networkMap;
        synchronized (map) {
            for (NetworkAttr cur : this.networkMap.values()) {
                Status status = (Status)this.statusMap.get(NetworkIdUtil.toString((NetworkId)cur.get_id()));
                if ((this.useStanding.size() != 0 || this.notUseStanding.contains(status.getStanding())) && !this.useStanding.contains(status.getStanding())) continue;
                Iterator tempIt = this.templates.iterator();
                while (tempIt.hasNext()) {
                    buf.append(((NetworkTemplate)tempIt.next()).getResult(cur));
                }
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(NetworkAttrImpl net, Status status) {
        Map map = this.networkMap;
        synchronized (map) {
            String id = NetworkIdUtil.toString((NetworkId)net.get_id());
            this.statusMap.put(id, status);
            this.networkMap.put(id, net);
        }
    }
}

