/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.chooser.CoarseAvailableData;
import edu.sc.seis.fissuresUtil.mseed.FissuresConvert;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import edu.sc.seis.seisFile.ChannelTimeWindow;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.DataAvailability;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationIterator;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.DataRecordIterator;
import edu.sc.seis.sod.BuildVersion;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.source.network.FdsnStation;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.WrappingNetworkSource;
import edu.sc.seis.sod.source.seismogram.ConstantSeismogramSourceLocator;
import edu.sc.seis.sod.source.seismogram.SeismogramAuthorizationException;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class FdsnDataSelect
extends ConstantSeismogramSourceLocator
implements SeismogramSourceLocator {
    private FDSNDataSelectQueryParams queryParams = new FDSNDataSelectQueryParams();
    private int timeoutMillis = 10000;
    FdsnStation fdsnStation = null;
    CoarseAvailableData availableData;
    private String username;
    private String password;
    private static final Logger logger = LoggerFactory.getLogger(FdsnDataSelect.class);

    public FdsnDataSelect() {
        super("DefaultFDSNDataSelect");
        this.timeoutMillis = 10000;
        this.username = "";
        this.password = "";
        this.checkFdsnStationLinkage();
    }

    public FdsnDataSelect(Element config) throws MalformedURLException, URISyntaxException {
        this(config, "service.iris.edu");
    }

    public FdsnDataSelect(Element config, String defaultHost) throws MalformedURLException, URISyntaxException {
        super(config, "DefaultFDSNDataSelect", 2);
        String fdsnwsPath;
        String host;
        int port = SodUtil.loadInt(config, "port", -1);
        if (port > 0) {
            this.queryParams.setPort(port);
        }
        if ((host = SodUtil.loadText(config, "host", defaultHost)) != null && host.length() != 0) {
            this.queryParams.setHost(host);
        }
        if ((fdsnwsPath = SodUtil.loadText(config, "fdsnwsPath", null)) != null && fdsnwsPath.length() != 0) {
            this.queryParams.setFdsnwsPath(fdsnwsPath);
        }
        this.username = SodUtil.loadText(config, "user", "");
        this.password = SodUtil.loadText(config, "password", "");
        this.timeoutMillis = 1000 * SodUtil.loadInt(config, "timeoutSecs", 10);
        this.checkFdsnStationLinkage();
    }

    private void checkFdsnStationLinkage() {
        NetworkSource wrappedNetSource = (WrappingNetworkSource)Start.getNetworkArm().getNetworkSource();
        while (wrappedNetSource instanceof WrappingNetworkSource) {
            wrappedNetSource = ((WrappingNetworkSource)wrappedNetSource).getWrapped();
        }
        if (wrappedNetSource instanceof FdsnStation) {
            this.fdsnStation = (FdsnStation)wrappedNetSource;
        } else {
            logger.warn("Can't do FdsnStation Linkage, net source no FdsnStation: " + wrappedNetSource.getClass().getCanonicalName());
        }
        if (!this.username.equals("") && !this.password.equals("") && Start.getNetworkArm() != null) {
            logger.info("User and password set, so including restricted in FdsnStation network source");
            this.fdsnStation.includeRestricted(true);
        }
        if (this.fdsnStation != null) {
            this.availableData = this.fdsnStation.getAvailableData();
        }
        if (this.availableData == null) {
            logger.warn("CoarseAvailableData is null, cannot do available data check.");
        }
    }

    public FdsnDataSelect(String host, int port, CoarseAvailableData fdsnStationAvailability) {
        super(host, 2);
        this.queryParams.setHost(host);
        this.queryParams.setPort(port);
        this.availableData = fdsnStationAvailability;
    }

    @Override
    public SeismogramSource getSeismogramSource() {
        return new SeismogramSource(){

            @Override
            public List<RequestFilter> availableData(List<RequestFilter> request) throws SeismogramSourceException {
                if (FdsnDataSelect.this.availableData == null) {
                    return this.internalAvailableData(request);
                }
                ArrayList<RequestFilter> out = new ArrayList<RequestFilter>();
                for (RequestFilter rf : request) {
                    if (!FdsnDataSelect.this.availableData.isCached(rf.channel_id)) continue;
                    List avail = FdsnDataSelect.this.availableData.get(rf.channel_id);
                    MicroSecondTimeRange reqRange = new MicroSecondTimeRange(rf);
                    for (MicroSecondTimeRange range : avail) {
                        MicroSecondTimeRange intersect = reqRange.intersection(range);
                        if (intersect == null) continue;
                        out.add(new RequestFilter(rf.channel_id, intersect.getBeginTime().getFissuresTime(), intersect.getEndTime().getFissuresTime()));
                    }
                }
                return out;
            }

            @Override
            public List<LocalSeismogramImpl> retrieveData(List<RequestFilter> request) throws SeismogramSourceException {
                int count = 0;
                SeismogramSourceException latest = null;
                while (count == 0 || FdsnDataSelect.this.getRetryStrategy().shouldRetry((Throwable)latest, (Object)this, count++)) {
                    try {
                        List<LocalSeismogramImpl> result = this.internalRetrieveData(request);
                        FdsnDataSelect.this.getRetryStrategy().serverRecovered((Object)this);
                        return result;
                    }
                    catch (SeismogramSourceException t) {
                        latest = t;
                        Throwable rootCause = AbstractFDSNQuerier.extractRootCause((Throwable)t);
                        if (t.getCause() == null) {
                            throw t;
                        }
                        if (rootCause instanceof IOException || t.getCause() instanceof FDSNWSException && ((FDSNWSException)t.getCause()).getHttpResponseCode() != 200) continue;
                        throw t;
                    }
                    catch (OutOfMemoryError e) {
                        throw new RuntimeException("Out of memory", e);
                    }
                }
                throw latest;
            }

            public List<RequestFilter> internalAvailableData(List<RequestFilter> request) throws SeismogramSourceException {
                if (FdsnDataSelect.this.availableData == null) {
                    return request;
                }
                try {
                    ArrayList<RequestFilter> out = new ArrayList<RequestFilter>();
                    if (request.size() != 0) {
                        FDSNStationQueryParams staQueryParams = new FDSNStationQueryParams(FdsnDataSelect.this.queryParams.getHost());
                        if (FdsnDataSelect.this.queryParams.getPort() > 0) {
                            staQueryParams.setPort(FdsnDataSelect.this.queryParams.getPort());
                        }
                        staQueryParams.setIncludeAvailability(true);
                        staQueryParams.setLevel("channel");
                        for (RequestFilter rf : request) {
                            ChannelId c = rf.channel_id;
                            staQueryParams.appendToNetwork(c.network_id.network_code);
                            staQueryParams.appendToStation(c.station_code);
                            staQueryParams.appendToLocation(c.site_code);
                            staQueryParams.appendToChannel(c.channel_code);
                        }
                        try {
                            logger.info("availavle data query: " + staQueryParams.formURI());
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                        FDSNStationQuerier querier = new FDSNStationQuerier(staQueryParams);
                        NetworkIterator nIt = querier.getFDSNStationXML().getNetworks();
                        while (nIt.hasNext()) {
                            Network n = nIt.next();
                            StationIterator sIt = n.getStations();
                            while (sIt.hasNext()) {
                                Station s = sIt.next();
                                List chanList = s.getChannelList();
                                for (Channel channel : chanList) {
                                    DataAvailability da = channel.getDataAvailability();
                                    if (da == null || da.getExtent() == null) continue;
                                    out.add(new RequestFilter(new ChannelId(new NetworkId(n.getCode(), new MicroSecondDate(n.getStartDate()).getFissuresTime()), s.getCode(), channel.getLocCode(), channel.getCode(), new MicroSecondDate(channel.getStartDate()).getFissuresTime()), new MicroSecondDate(da.getExtent().getStart()).getFissuresTime(), new MicroSecondDate(da.getExtent().getEnd()).getFissuresTime()));
                                }
                            }
                        }
                    }
                    return ReduceTool.trimTo(out, request);
                }
                catch (FDSNWSException e) {
                    throw new SeismogramSourceException(e);
                }
                catch (SeisFileException e) {
                    throw new SeismogramSourceException(e);
                }
                catch (XMLStreamException e) {
                    throw new SeismogramSourceException(e);
                }
            }

            public List<LocalSeismogramImpl> internalRetrieveData(List<RequestFilter> request) throws SeismogramSourceException {
                ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
                if (request.size() != 0) {
                    FDSNDataSelectQueryParams newQueryParams = FdsnDataSelect.this.queryParams.clone();
                    ArrayList<ChannelTimeWindow> queryRequest = new ArrayList<ChannelTimeWindow>();
                    for (RequestFilter rf : request) {
                        ChannelId c = rf.channel_id;
                        queryRequest.add(new ChannelTimeWindow(c.network_id.network_code, c.station_code, c.site_code, c.channel_code, (Date)new MicroSecondDate(rf.start_time), (Date)new MicroSecondDate(rf.end_time)));
                    }
                    List<DataRecord> drList = this.retrieveData(newQueryParams, queryRequest, FdsnDataSelect.this.getRetries());
                    try {
                        List<LocalSeismogramImpl> perRFList = FissuresConvert.toFissures(drList);
                        perRFList = Arrays.asList(ReduceTool.merge((LocalSeismogramImpl[])perRFList.toArray(new LocalSeismogramImpl[0])));
                        block4: for (LocalSeismogramImpl seis : perRFList) {
                            for (RequestFilter rf : request) {
                                if (rf.channel_id.network_id.network_code.equals(seis.channel_id.network_id.network_code)) {
                                    seis.channel_id.network_id.begin_time = rf.channel_id.network_id.begin_time;
                                }
                                if (!ChannelIdUtil.areEqualExceptForBeginTime((ChannelId)rf.channel_id, (ChannelId)seis.channel_id)) continue;
                                seis.channel_id.begin_time = rf.channel_id.begin_time;
                                continue block4;
                            }
                        }
                        out.addAll(perRFList);
                    }
                    catch (SeisFileException e) {
                        throw new SeismogramSourceException(e);
                    }
                    catch (FissuresException e) {
                        throw new SeismogramSourceException(e);
                    }
                }
                return out;
            }

            public List<DataRecord> retrieveData(FDSNDataSelectQueryParams queryParams, List<ChannelTimeWindow> queryRequest, int tryCount) throws SeismogramSourceException {
                ArrayList<DataRecord> drList = new ArrayList<DataRecord>();
                FDSNDataSelectQuerier querier = new FDSNDataSelectQuerier(queryParams, queryRequest);
                querier.setConnectTimeout(FdsnDataSelect.this.timeoutMillis);
                querier.setReadTimeout(FdsnDataSelect.this.timeoutMillis);
                String restrictedStr = "query: ";
                if (FdsnDataSelect.this.username != null && FdsnDataSelect.this.username.length() != 0 && FdsnDataSelect.this.password != null && FdsnDataSelect.this.password.length() != 0) {
                    querier.enableRestrictedData(FdsnDataSelect.this.username, FdsnDataSelect.this.password);
                    restrictedStr = "restricted " + restrictedStr;
                }
                try {
                    logger.info(restrictedStr + queryParams.formURI());
                }
                catch (URISyntaxException e) {
                    throw new SeismogramSourceException("Error with URL syntax", e);
                }
                querier.setUserAgent("SOD/" + BuildVersion.getVersion());
                try {
                    DataRecordIterator drIt = querier.getDataRecordIterator();
                    while (drIt.hasNext()) {
                        drList.add(drIt.next());
                    }
                }
                catch (FDSNWSException e) {
                    if (querier.getResponseCode() == 401 || querier.getResponseCode() == 403) {
                        throw new SeismogramAuthorizationException("Authorization failure to " + e.getTargetURI(), e);
                    }
                    throw new SeismogramSourceException(e);
                }
                catch (SeisFileException e) {
                    throw new SeismogramSourceException(e);
                }
                catch (SocketTimeoutException e) {
                    logger.info("Timeout, will retry " + --tryCount + " more times");
                    if (tryCount > 0) {
                        return this.retrieveData(queryParams, queryRequest, tryCount);
                    }
                    throw new SeismogramSourceException("Retries exceeded", e);
                }
                catch (IOException e) {
                    throw new SeismogramSourceException(e);
                }
                return drList;
            }
        };
    }
}

