/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.NSSeismogramDC;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCenterSource
implements SeismogramSource {
    ProxySeismogramDC seisDC;
    public static final String RETRIEVING_DATA = "Processing";
    public static final String DATA_RETRIEVED = "Finished";
    public static final String NO_DATA = "no_data";
    private static final Logger logger = LoggerFactory.getLogger(DataCenterSource.class);

    public DataCenterSource(ProxySeismogramDC seisDC) {
        this.seisDC = seisDC;
    }

    @Override
    public List<RequestFilter> availableData(List<RequestFilter> request) {
        return DataCenterSource.toList(this.seisDC.available_data(DataCenterSource.toArray(request)));
    }

    @Override
    public List<LocalSeismogramImpl> retrieveData(List<RequestFilter> request) throws SeismogramSourceException {
        try {
            int i;
            RequestFilter[] infilters = DataCenterSource.toArray(request);
            LocalSeismogram[] localSeismograms = new LocalSeismogram[]{};
            logger.debug("before retrieve_seismograms");
            NSSeismogramDC nsDC = (NSSeismogramDC)this.seisDC.getWrappedDC(NSSeismogramDC.class);
            if (nsDC.getServerDNS().equals("edu/iris/dmc") && nsDC.getServerName().equals("IRIS_ArchiveDataCenter")) {
                String id = this.seisDC.queue_seismograms(infilters);
                logger.info("request id: " + id);
                String status = this.seisDC.request_status(id);
                i = 0;
                while (status.equals(RETRIEVING_DATA) && i < 60) {
                    logger.info("Waiting for data to be returned from the archive.  We've been waiting for " + i++ + " minutes");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    status = this.seisDC.request_status(id);
                }
                if (status.equals(DATA_RETRIEVED)) {
                    localSeismograms = this.seisDC.retrieve_queue(id);
                } else if (status.equals(RETRIEVING_DATA)) {
                    this.seisDC.cancel_request(id);
                    throw new SeismogramSourceException("Looks like the archive lost request ID " + id + ".  No data was returned after " + i + " minutes. ");
                }
            } else {
                localSeismograms = this.seisDC.retrieve_seismograms(infilters);
            }
            logger.debug("after successful retrieve_seismograms");
            if (localSeismograms.length > 0 && !ChannelIdUtil.areEqual((ChannelId)localSeismograms[0].channel_id, (ChannelId)infilters[0].channel_id)) {
                logger.warn("X Channel id in returned seismogram doesn not match channelid in request. req=" + ChannelIdUtil.toString((ChannelId)infilters[0].channel_id) + " seis=" + ChannelIdUtil.toString((ChannelId)localSeismograms[0].channel_id));
            }
            ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
            LocalSeismogram[] fromServer = this.seisDC.retrieve_seismograms(request.toArray(new RequestFilter[0]));
            for (i = 0; i < fromServer.length; ++i) {
                out.add((LocalSeismogramImpl)fromServer[i]);
            }
            return out;
        }
        catch (FissuresException e) {
            throw new SeismogramSourceException(e);
        }
    }

    public ProxySeismogramDC getDataCenter() {
        return this.seisDC;
    }

    public static List<RequestFilter> toList(RequestFilter[] in) {
        ArrayList<RequestFilter> out = new ArrayList<RequestFilter>();
        for (int i = 0; i < in.length; ++i) {
            out.add(in[i]);
        }
        return out;
    }

    public static RequestFilter[] toArray(List<RequestFilter> in) {
        return in.toArray(new RequestFilter[0]);
    }

    public static LocalSeismogramImpl[] toSeisArray(List<LocalSeismogramImpl> data) {
        return data.toArray(new LocalSeismogramImpl[0]);
    }
}

