/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.seisFile.waveserver.MenuItem;
import edu.sc.seis.seisFile.waveserver.WaveServer;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.network.CSVNetworkSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class WinstonNetworkSource
extends CSVNetworkSource {
    private String defaultHost = "eeyore.seis.sc.edu";
    private String host;
    private int port;
    private WaveServer ws;
    private static final Logger logger = LoggerFactory.getLogger(WinstonNetworkSource.class);

    public WinstonNetworkSource(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    protected void initChannels(Element config) throws ConfigurationException {
        this.host = SodUtil.loadText(config, "host", this.defaultHost);
        this.port = SodUtil.loadInt(config, "port", 16022);
        try {
            List winstonMenu = this.getWaveServer().getMenu();
            this.channels = new ArrayList();
            for (MenuItem menuItem : winstonMenu) {
                try {
                    String netCode = menuItem.getNetwork();
                    String staCode = menuItem.getStation();
                    String chanCode = menuItem.getChannel();
                    String siteCode = menuItem.getLocation();
                    try {
                        StationImpl curStation = this.getStationForChannel(netCode, staCode);
                        if (curStation == null) {
                            logger.warn("Can't find station for " + netCode + "." + staCode + ", skipping");
                            continue;
                        }
                        float azimuth = ChannelImpl.getAzimuth((String)chanCode);
                        float dip = ChannelImpl.getDip((String)chanCode);
                        SamplingImpl sampling = new SamplingImpl(1, new TimeInterval(1.0, UnitImpl.SECOND));
                        Time chanStart = curStation.getBeginTime();
                        if (menuItem.getStartDate().before((Date)ClockUtil.now())) {
                            chanStart = new MicroSecondDate(Math.round(1000000.0 * menuItem.getStart())).getFissuresTime();
                        }
                        TimeRange chanTime = new TimeRange(chanStart, DEFAULT_END);
                        ChannelImpl channelImpl = new ChannelImpl(new ChannelId(curStation.get_id().network_id, staCode, siteCode, chanCode, chanTime.start_time), "", new Orientation(azimuth, dip), (Sampling)sampling, chanTime, (Site)new SiteImpl(new SiteId(curStation.get_id().network_id, staCode, siteCode, chanTime.start_time), (Station)curStation, ""));
                        this.channels.add(channelImpl);
                    }
                    catch (Throwable t) {
                        logger.warn("problem with channel, " + netCode + "." + staCode + "." + siteCode + "." + chanCode + " skipping", t);
                    }
                }
                catch (Throwable t) {
                    logger.warn("problem with channel, skipping", t);
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to get menu from waveserver: (" + this.host + ", " + this.port + ")", e);
        }
    }

    public WaveServer getWaveServer() {
        if (this.ws == null) {
            this.ws = new WaveServer(this.host, this.port);
        }
        return this.ws;
    }
}

