/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.InstrumentationImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.fissuresUtil.stationxml.ChannelSensitivityBundle;
import edu.sc.seis.fissuresUtil.stationxml.StationChannelBundle;
import edu.sc.seis.fissuresUtil.stationxml.StationXMLToFissures;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.network.AbstractNetworkSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@Deprecated
public class StationXML
extends AbstractNetworkSource
implements NetworkSource {
    NetworkQueryConstraints constraints;
    static String[] ignoreNets = new String[]{"AB", "AI", "BN"};
    List<NetworkAttrImpl> knownNetworks = new ArrayList<NetworkAttrImpl>();
    List<NetworkAttrImpl> networks;
    Map<String, List<StationChannelBundle>> staChanMap = new HashMap<String, List<StationChannelBundle>>();
    String url;
    URI parsedURL;
    TimeInterval refreshInterval;
    String lastLoadDate;
    public static final TimeInterval ONE_SECOND = new TimeInterval(1.0, UnitImpl.SECOND);
    public static final TimeInterval ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
    private static final Logger logger = LoggerFactory.getLogger(StationXML.class);
    public static final String URL_ELEMENT = "url";
    public static final byte[] EMPTY_STATIONXML = "<StaMessage xsi:schemaLocation=\"http://www.data.scec.org/xml/station/20120307/ http://www.data.scec.org/xml/station/20120307/station.xsd http://www.iris.edu/ws/schemas/station/2012/03/22/ http://www.iris.edu/ws/schemas/station/2012/03/22/station_comments.xsd\"/>".getBytes();

    public StationXML(Element config) throws ConfigurationException {
        super(config);
        if (DOMHelper.hasElement((Element)config, (String)URL_ELEMENT)) {
            this.url = SodUtil.getNestedText(SodUtil.getElement(config, URL_ELEMENT));
            this.checkForOldIrisWebService(this.url);
        }
        this.refreshInterval = DOMHelper.hasElement((Element)config, (String)"refreshInterval") ? SodUtil.loadTimeInterval(SodUtil.getElement(config, "refreshInterval")) : new TimeInterval(1.0, UnitImpl.FORTNIGHT);
        this.parseURL();
    }

    private void checkForOldIrisWebService(String url2) throws ConfigurationException {
        if (url2.startsWith("http://www.iris.edu/ws")) {
            throw new ConfigurationException("This URL appears to point to the deprecated IRIS DMC station web service. This uses the older stationXML schema which is no longer supported by SOD. Please use the new FDSN Station web service with the <fdsnStation> network source.");
        }
    }

    void parseURL() throws ConfigurationException {
        try {
            this.parsedURL = new URI(this.url);
            ArrayList<String> split = new ArrayList<String>();
            if (this.parsedURL.getQuery() != null) {
                String[] splitArray;
                for (String s : splitArray = this.parsedURL.getQuery().split("&")) {
                    String[] nvSplit = s.split("=");
                    if (nvSplit[0].equals("level")) continue;
                    split.add(s);
                }
                String newQuery = "";
                boolean first = true;
                for (String s : split) {
                    if (!first) {
                        newQuery = newQuery + "&";
                    }
                    newQuery = newQuery + s;
                    first = false;
                }
                this.parsedURL = new URI(this.parsedURL.getScheme(), this.parsedURL.getUserInfo(), this.parsedURL.getHost(), this.parsedURL.getPort(), this.parsedURL.getPath(), newQuery, this.parsedURL.getFragment());
            }
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid <url> element found.", e);
        }
    }

    public String getDNS() {
        return this.url;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public TimeInterval getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public CacheNetworkAccess getNetwork(NetworkAttrImpl attr) {
        return new CacheNetworkAccess(null, attr);
    }

    @Override
    public List<? extends CacheNetworkAccess> getNetworkByName(String name) throws NetworkNotFound {
        throw new NetworkNotFound();
    }

    @Override
    public List<? extends NetworkAttrImpl> getNetworks() {
        this.checkNetsLoaded();
        return Collections.unmodifiableList(this.networks);
    }

    @Override
    public List<? extends StationImpl> getStations(NetworkAttrImpl net) {
        this.checkChansLoaded(NetworkIdUtil.toStringNoDates((NetworkAttr)net));
        List<StationChannelBundle> bundles = this.staChanMap.get(NetworkIdUtil.toStringNoDates((NetworkAttr)net));
        ArrayList<StationImpl> out = new ArrayList<StationImpl>();
        for (StationChannelBundle b : bundles) {
            out.add(b.getStation());
        }
        return out;
    }

    @Override
    public List<? extends ChannelImpl> getChannels(StationImpl station) {
        this.checkChansLoaded(NetworkIdUtil.toStringNoDates((NetworkAttr)station.getNetworkAttr()));
        List<StationChannelBundle> bundles = this.staChanMap.get(NetworkIdUtil.toStringNoDates((NetworkAttr)station.getNetworkAttr()));
        for (StationChannelBundle b : bundles) {
            if (!StationIdUtil.areEqual((edu.iris.Fissures.IfNetwork.Station)station, (edu.iris.Fissures.IfNetwork.Station)b.getStation())) continue;
            ArrayList<ChannelImpl> out = new ArrayList<ChannelImpl>();
            for (ChannelSensitivityBundle chanSens : b.getChanList()) {
                out.add(chanSens.getChan());
            }
            return out;
        }
        return new ArrayList();
    }

    @Override
    public QuantityImpl getSensitivity(ChannelImpl chan) throws ChannelNotFound, InvalidResponse {
        this.checkChansLoaded(NetworkIdUtil.toStringNoDates((NetworkId)chan.getId().network_id));
        List<StationChannelBundle> bundles = this.staChanMap.get(NetworkIdUtil.toStringNoDates((NetworkId)chan.getId().network_id));
        for (StationChannelBundle b : bundles) {
            if (!chan.getId().station_code.equals(b.getStation().get_code())) continue;
            for (ChannelSensitivityBundle chanSens : b.getChanList()) {
                if (!ChannelIdUtil.areEqual((ChannelId)chan.getId(), (ChannelId)chanSens.getChan().get_id()) || chanSens.getSensitivity() == null) continue;
                return chanSens.getSensitivity();
            }
        }
        throw new ChannelNotFound();
    }

    @Override
    public Instrumentation getInstrumentation(ChannelImpl chan) throws ChannelNotFound, InvalidResponse {
        MicroSecondDate chanBegin = new MicroSecondDate(chan.getId().begin_time);
        String newQuery = "network=" + chan.getId().network_id.network_code + "&" + "station" + "=" + chan.getId().station_code + "&" + "location" + "=" + chan.getId().site_code + "&" + "channel" + "=" + chan.getId().channel_code + "&" + "starttime" + "=" + StationXML.toDateString(chanBegin) + "&" + "endtime" + "=" + StationXML.toDateString(chanBegin.add(ONE_DAY));
        try {
            URI chanUri = new URI(this.parsedURL.getScheme(), this.parsedURL.getUserInfo(), this.parsedURL.getHost(), this.parsedURL.getPort(), this.parsedURL.getPath(), newQuery, this.parsedURL.getFragment());
            FDSNStationXML sm = StationXML.retrieveXML(chanUri, "resp");
            NetworkIterator netIt = sm.getNetworks();
            while (netIt.hasNext()) {
                Network n = netIt.next();
                StationIterator staIt = n.getStations();
                while (staIt.hasNext()) {
                    Station s = staIt.next();
                    for (Channel c : s.getChannelList()) {
                        InstrumentationImpl inst = StationXMLToFissures.convertInstrumentation((Channel)c);
                        if (RangeTool.areOverlapping((MicroSecondTimeRange)new MicroSecondTimeRange(inst.effective_time), (MicroSecondTimeRange)new MicroSecondTimeRange(chanBegin.add(ONE_SECOND), chanBegin.add(ONE_DAY)))) {
                            return inst;
                        }
                        logger.debug("Skipping as wrong start time " + ChannelIdUtil.toString((ChannelId)chan.getId()) + " " + inst.effective_time.start_time.date_time + " " + inst.effective_time.end_time.date_time);
                    }
                }
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidResponse("StationXML URL is not valid, should not happen but it did.", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new InvalidResponse("Problem getting response via stationxml.", (Throwable)e);
        }
        catch (StationXMLException e) {
            throw new InvalidResponse("Problem getting response via stationxml.", (Throwable)e);
        }
        catch (IOException e) {
            throw new InvalidResponse("Problem getting response via stationxml.", (Throwable)e);
        }
        throw new ChannelNotFound();
    }

    @Override
    public void setConstraints(NetworkQueryConstraints constraints) {
        this.constraints = constraints;
    }

    synchronized void checkNetsLoaded() {
        if (this.networks == null) {
            try {
                this.parseNets();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    synchronized void checkChansLoaded(String netCode) {
        if (this.staChanMap.get(netCode) == null) {
            this.checkNetsLoaded();
            try {
                this.parse();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FDSNStationXML retrieveXML(URI u, String level) throws XMLStreamException, StationXMLException, IOException, URISyntaxException {
        URI chanUri = new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), u.getPath(), u.getQuery() + "&level=" + level, u.getFragment());
        logger.info("Retrieve from " + chanUri);
        URLConnection urlConn = chanUri.toURL().openConnection();
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection conn = (HttpURLConnection)urlConn;
            if (conn.getResponseCode() == 204) {
                return StationXML.retrieveXML(new ByteArrayInputStream(EMPTY_STATIONXML));
            }
            if (conn.getResponseCode() != 200) {
                String out = "";
                BufferedReader errReader = null;
                try {
                    String line;
                    errReader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                    while ((line = errReader.readLine()) != null) {
                        out = out + line + "\n";
                    }
                }
                finally {
                    if (errReader != null) {
                        errReader.close();
                        conn.disconnect();
                    }
                }
                throw new StationXMLException("Error in connection with url: " + chanUri + "  " + out);
            }
        }
        return StationXML.retrieveXML(urlConn.getInputStream());
    }

    static FDSNStationXML retrieveXML(InputStream inStream) throws XMLStreamException, StationXMLException, IOException, URISyntaxException {
        BufferedInputStream in = new BufferedInputStream(inStream);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader r = factory.createXMLEventReader(in);
        XMLEvent e = r.peek();
        while (!e.isStartElement()) {
            e = r.nextEvent();
            e = r.peek();
        }
        return new FDSNStationXML(r);
    }

    synchronized void parseNets() throws XMLStreamException, StationXMLException, IOException, URISyntaxException {
        this.networks = new ArrayList<NetworkAttrImpl>();
        logger.info("Parsing networks from " + this.parsedURL);
        FDSNStationXML stationXML = StationXML.retrieveXML(this.parsedURL, "network");
        NetworkIterator netIt = stationXML.getNetworks();
        while (netIt.hasNext()) {
            Network net = netIt.next();
            this.networks.add(StationXMLToFissures.convert((Network)net));
            StationIterator it = net.getStations();
            while (it.hasNext()) {
                Station station = it.next();
            }
        }
        stationXML.closeReader();
        logger.info("found " + this.networks.size() + " networks after parse");
    }

    synchronized void parse() throws XMLStreamException, StationXMLException, IOException, URISyntaxException {
        this.staChanMap.clear();
        int numChannels = 0;
        logger.info("Parsing channels from " + this.parsedURL);
        FDSNStationXML stationXML = StationXML.retrieveXML(this.parsedURL, "channel");
        this.lastLoadDate = stationXML.getCreated();
        NetworkIterator netIt = stationXML.getNetworks();
        while (netIt.hasNext()) {
            Network net = netIt.next();
            String key = NetworkIdUtil.toStringNoDates((NetworkId)StationXMLToFissures.convert((Network)net).getId());
            if (!this.staChanMap.containsKey(key)) {
                this.staChanMap.put(key, new ArrayList());
            }
            StationIterator it = net.getStations();
            while (it.hasNext()) {
                Station s = it.next();
                try {
                    numChannels += this.processStation(this.networks, s);
                }
                catch (StationXMLException ee) {
                    logger.error("Skipping " + s.getNetworkCode() + "." + s.getCode() + " " + ee.getMessage());
                }
            }
        }
        logger.info("found " + numChannels + " channels in " + this.networks.size() + " networks after parse ");
    }

    int processStation(List<NetworkAttrImpl> netList, Station s) throws StationXMLException {
        int numChannels = 0;
        for (String ignore : ignoreNets) {
            if (!s.getNetworkCode().equals(ignore)) continue;
            return 0;
        }
        List bundles = StationXMLToFissures.convert((Station)s, netList, (boolean)true);
        for (StationChannelBundle b : bundles) {
            String staKey = NetworkIdUtil.toStringNoDates((NetworkAttr)b.getStation().getNetworkAttr());
            if (!this.staChanMap.containsKey(staKey)) {
                this.staChanMap.put(staKey, new ArrayList());
            }
            this.staChanMap.get(staKey).add(b);
            numChannels += b.getChanList().size();
        }
        return numChannels;
    }

    public static String toDateString(MicroSecondDate msd) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format((Date)msd);
    }
}

