/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.source.event.EventFinder;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class BackwardsEventFinder
extends EventFinder {
    private static final Logger logger = LoggerFactory.getLogger(BackwardsEventFinder.class);

    public BackwardsEventFinder(Element config) throws Exception {
        super(config);
    }

    @Override
    public String getDescription() {
        return "Backwards " + super.getDescription();
    }

    @Override
    public boolean hasNext() {
        MicroSecondTimeRange currentQuery = this.getQueryTime();
        MicroSecondDate queryBegin = this.getEventTimeRange().getBeginTime();
        logger.debug("Checking if more queries to the event server are in order. The last query was  " + currentQuery + " and we're querying from " + currentQuery.getBeginTime().subtract(this.increment));
        return !currentQuery.getEndTime().equals((Object)queryBegin);
    }

    @Override
    public CacheEvent[] next() {
        CacheEvent[] results = super.next();
        CacheEvent[] out = new CacheEvent[results.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = results[results.length - i - 1];
        }
        return out;
    }

    @Override
    protected boolean caughtUpWithRealtime() {
        return false;
    }

    @Override
    protected void updateQueryEdge(MicroSecondTimeRange queryTime) {
        this.setQueryEdge(queryTime.getBeginTime());
    }

    @Override
    protected MicroSecondDate getQueryStart() {
        try {
            return this.getQueryEdge();
        }
        catch (NotFound e) {
            logger.debug("the query times database didn't have an entry for our server/dns combo, just use the time in the config file");
            return this.getEventTimeRange().getEndTime();
        }
    }

    @Override
    protected MicroSecondTimeRange getQueryTime() {
        MicroSecondDate queryEnd = this.getQueryStart();
        MicroSecondDate queryStart = queryEnd.subtract(this.increment);
        if (this.getEventTimeRange().getBeginTime().after((Date)queryStart)) {
            queryStart = this.getEventTimeRange().getBeginTime();
        }
        return new MicroSecondTimeRange(queryStart, queryEnd);
    }
}

