/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import org.w3c.dom.Element;

public class Taper
implements WaveformProcess,
Threadable {
    edu.sc.seis.fissuresUtil.bag.Taper taper;

    public Taper(Element config) {
        Element widthElement;
        int type = edu.sc.seis.fissuresUtil.bag.Taper.HANNING;
        Element typeElement = SodUtil.getElement(config, "type");
        if (typeElement != null) {
            String typeStr = SodUtil.getText(typeElement);
            if (typeStr.equals("hanning")) {
                type = edu.sc.seis.fissuresUtil.bag.Taper.HANNING;
            } else if (typeStr.equals("hamming")) {
                type = edu.sc.seis.fissuresUtil.bag.Taper.HANNING;
            } else if (typeStr.equals("cosine")) {
                type = edu.sc.seis.fissuresUtil.bag.Taper.COSINE;
            }
        }
        if ((widthElement = SodUtil.getElement(config, "width")) != null) {
            float width = Float.parseFloat(SodUtil.getText(widthElement));
            this.taper = new edu.sc.seis.fissuresUtil.bag.Taper(type, width);
        } else {
            this.taper = new edu.sc.seis.fissuresUtil.bag.Taper((float)type);
        }
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
        for (int i = 0; i < seismograms.length; ++i) {
            out[i] = this.taper.apply(seismograms[i]);
        }
        return new WaveformResult(out, new StringTreeLeaf(this, true));
    }
}

