/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.velocity.PrintlineVelocitizer;
import java.io.IOException;
import org.w3c.dom.Element;

public class PrintlineSeismogramProcess
implements WaveformProcess {
    private PrintlineVelocitizer velocitizer;
    private String template;
    private String filename;
    public static final String DEFAULT_TEMPLATE = "Got $seismograms.size() seismograms for $channel.toString() for eq on $event.time";

    public PrintlineSeismogramProcess(Element config) throws ConfigurationException {
        this.filename = DOMHelper.extractText((Element)config, (String)"filename", (String)"");
        this.template = DOMHelper.extractText((Element)config, (String)"template", (String)DEFAULT_TEMPLATE);
        this.velocitizer = new PrintlineVelocitizer(new String[]{this.filename, this.template});
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws IOException {
        this.velocitizer.evaluate(this.filename, this.template, (EventAccessOperations)event, channel, original, available, seismograms, cookieJar);
        return new WaveformResult(seismograms, new StringTreeLeaf(this, true));
    }
}

