/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import com.oregondsp.signalProcessing.filter.iir.Butterworth;
import com.oregondsp.signalProcessing.filter.iir.ChebyshevI;
import com.oregondsp.signalProcessing.filter.iir.ChebyshevII;
import com.oregondsp.signalProcessing.filter.iir.IIRFilter;
import com.oregondsp.signalProcessing.filter.iir.PassbandType;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OregonDSPFilter
implements WaveformProcess {
    Element config;
    String filterName = "butterworth";
    PassbandType passband = PassbandType.BANDPASS;
    double epsilon = 1.0;
    QuantityImpl lowFreqCorner;
    QuantityImpl highFreqCorner;
    int numPoles = 2;
    int filterType = 1;

    public OregonDSPFilter(String filterName, PassbandType passband, double epsilon, QuantityImpl lowFreqCorner, QuantityImpl highFreqCorner, int numPoles, int filterType) {
        this.filterName = filterName;
        this.passband = passband;
        this.epsilon = epsilon;
        this.setLowFreqCorner(lowFreqCorner);
        this.setHighFreqCorner(highFreqCorner);
        this.numPoles = numPoles;
        this.filterType = filterType;
    }

    public OregonDSPFilter(Element config) throws ConfigurationException {
        this.config = config;
        if (config != null) {
            NodeList childNodes = config.getChildNodes();
            for (int counter = 0; counter < childNodes.getLength(); ++counter) {
                Node node = childNodes.item(counter);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                if (element.getTagName().equals("lowFreqCorner")) {
                    this.setLowFreqCorner(SodUtil.loadQuantity(element));
                    continue;
                }
                if (element.getTagName().equals("highFreqCorner")) {
                    this.setHighFreqCorner(SodUtil.loadQuantity(element));
                    continue;
                }
                if (element.getTagName().equals("numPoles")) {
                    this.numPoles = Integer.parseInt(XMLUtil.getText((Element)element));
                    continue;
                }
                if (element.getTagName().equals("epsilon")) {
                    this.epsilon = Double.parseDouble(XMLUtil.getText((Element)element));
                    continue;
                }
                if (element.getTagName().equals("filterType")) {
                    if (XMLUtil.getText((Element)element).equals("CAUSAL")) {
                        this.filterType = 0;
                        continue;
                    }
                    this.filterType = 1;
                    continue;
                }
                if (element.getTagName().equals("butterworth")) {
                    this.filterName = element.getTagName();
                    continue;
                }
                if (element.getTagName().equals("chebyshevI")) {
                    this.filterName = element.getTagName();
                    continue;
                }
                if (element.getTagName().equals("chebyshevII")) {
                    this.filterName = element.getTagName();
                    continue;
                }
                if (element.getTagName().equals("bandpass")) {
                    this.passband = PassbandType.BANDPASS;
                    continue;
                }
                if (element.getTagName().equals("lowpass")) {
                    this.passband = PassbandType.LOWPASS;
                    continue;
                }
                if (!element.getTagName().equals("highpass")) continue;
                this.passband = PassbandType.HIGHPASS;
            }
        }
    }

    public OregonDSPFilter(Element config, PassbandType passband, QuantityImpl lowFreqCorner, QuantityImpl highFreqCorner) throws ConfigurationException {
        this(config);
        this.passband = passband;
        this.lowFreqCorner = lowFreqCorner;
        this.highFreqCorner = highFreqCorner;
    }

    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        return this.apply(seismograms);
    }

    public WaveformResult apply(LocalSeismogramImpl[] seismograms) throws FissuresException {
        IIRFilter filter = null;
        LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
        for (int i = 0; i < seismograms.length; ++i) {
            if (filter == null) {
                filter = this.createFilter(seismograms[0].getSampling().getPeriod().getValue(UnitImpl.SECOND));
            }
            float[] data = seismograms[i].get_as_floats();
            filter.filter(data);
            out[i] = new LocalSeismogramImpl((SeismogramAttr)seismograms[i], data);
            if (i >= seismograms.length - 1 || RangeTool.areContiguous((LocalSeismogramImpl)seismograms[i], (LocalSeismogramImpl)seismograms[i + 1])) continue;
            filter = null;
        }
        return new WaveformResult(out, new StringTreeLeaf(this, true));
    }

    IIRFilter createFilter(double delta) {
        Object filter = null;
        filter = this.filterName.equals("chebyshevI") ? new ChebyshevI(this.numPoles, this.epsilon, this.passband, this.lowFreqCorner.getValue(UnitImpl.HERTZ), this.highFreqCorner.getValue(UnitImpl.HERTZ), delta) : (this.filterName.equals("chebyshevII") ? new ChebyshevII(this.numPoles, this.epsilon, this.passband, this.lowFreqCorner.getValue(UnitImpl.HERTZ), this.highFreqCorner.getValue(UnitImpl.HERTZ), delta) : new Butterworth(this.numPoles, this.passband, this.lowFreqCorner.getValue(UnitImpl.HERTZ), this.highFreqCorner.getValue(UnitImpl.HERTZ), delta));
        return filter;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public PassbandType getPassband() {
        return this.passband;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public QuantityImpl getLowFreqCorner() {
        return this.lowFreqCorner;
    }

    protected void setLowFreqCorner(QuantityImpl lowFreqCorner) {
        if (lowFreqCorner != null && lowFreqCorner.get_unit().isConvertableTo(UnitImpl.SECOND)) {
            this.lowFreqCorner = lowFreqCorner.inverse();
        } else if (lowFreqCorner != null && lowFreqCorner.get_unit().isConvertableTo(UnitImpl.HERTZ)) {
            this.lowFreqCorner = lowFreqCorner;
        } else {
            throw new IllegalArgumentException("Corner freq must be convertible to SECONDS or HERTZ, but was: " + lowFreqCorner.get_unit());
        }
    }

    public QuantityImpl getHighFreqCorner() {
        return this.highFreqCorner;
    }

    protected void setHighFreqCorner(QuantityImpl highFreqCorner) {
        if (highFreqCorner != null && highFreqCorner.get_unit().isConvertableTo(UnitImpl.SECOND)) {
            this.highFreqCorner = highFreqCorner.inverse();
        } else if (highFreqCorner != null && highFreqCorner.get_unit().isConvertableTo(UnitImpl.HERTZ)) {
            this.highFreqCorner = highFreqCorner;
        } else {
            throw new IllegalArgumentException("Corner freq must be convertible to SECONDS or HERTZ, but was: " + highFreqCorner.get_unit());
        }
    }

    public int getNumPoles() {
        return this.numPoles;
    }

    public int getFilterType() {
        return this.filterType;
    }
}

