/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LongShortStoN;
import edu.sc.seis.fissuresUtil.bag.LongShortTrigger;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LongShortSignalToNoise
implements WaveformProcess,
Threadable {
    LongShortStoN sToN;
    TimeInterval longTime = new TimeInterval(100.0, UnitImpl.SECOND);
    TimeInterval shortTime = new TimeInterval(5.0, UnitImpl.SECOND);
    TimeInterval delayTime = (TimeInterval)this.shortTime.multiplyBy(2.0);
    float ratio;

    public LongShortSignalToNoise(Element config) throws ConfigurationException {
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            Node node = childNodes.item(counter);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getTagName().equals("longTime")) {
                this.longTime = SodUtil.loadTimeInterval(element);
                continue;
            }
            if (element.getTagName().equals("shortTime")) {
                this.shortTime = SodUtil.loadTimeInterval(element);
                continue;
            }
            if (element.getTagName().equals("delayTime")) {
                this.delayTime = SodUtil.loadTimeInterval(element);
                continue;
            }
            if (!element.getTagName().equals("ratio")) continue;
            this.ratio = Float.parseFloat(SodUtil.getNestedText(element));
        }
        this.sToN = new LongShortStoN(this.longTime, this.shortTime, this.ratio, this.delayTime);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        LongShortTrigger[] triggers = this.calcTriggers(seismograms);
        boolean hasTriggers = triggers.length != 0;
        return new WaveformResult(seismograms, new StringTreeLeaf(this, hasTriggers));
    }

    public LongShortTrigger[] calcTriggers(LocalSeismogramImpl[] seismograms) throws FissuresException {
        LinkedList<LongShortTrigger> out = new LinkedList<LongShortTrigger>();
        for (int i = 0; i < seismograms.length; ++i) {
            LongShortTrigger[] triggers = this.sToN.calcTriggers(seismograms[i]);
            for (int j = 0; j < triggers.length; ++j) {
                out.add(triggers[j]);
            }
        }
        return out.toArray(new LongShortTrigger[0]);
    }

    public String toString() {
        return "LongShortSignalToNoise";
    }
}

