/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import java.util.Date;
import java.util.Iterator;
import java.util.TimerTask;
import org.hibernate.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalLoserEventCleaner
extends TimerTask {
    TimeInterval lagInterval;
    private static final Logger logger = LoggerFactory.getLogger(TotalLoserEventCleaner.class);
    private static final long ONE_WEEK = 604800000L;

    public TotalLoserEventCleaner(TimeInterval lag) {
        this.lagInterval = lag;
    }

    @Override
    public void run() {
        try {
            logger.info("Working");
            MicroSecondDate ageAgo = ClockUtil.now().subtract(this.lagInterval);
            TimeInterval littleSkip = new TimeInterval(10.0, UnitImpl.MINUTE);
            TotalLoserEventCleaner.cleanEvents(ageAgo);
            StatefulEventDB.getSingleton().commit();
            logger.info("Cleaned events");
            ageAgo = ageAgo.add(littleSkip);
            TotalLoserEventCleaner.cleanECP(ageAgo);
            SodDB.getSingleton();
            SodDB.commit();
            logger.info("Cleaned event-channel pairs");
            TotalLoserEventCleaner.cleanEVP(ageAgo);
            SodDB.getSingleton();
            SodDB.commit();
            logger.info("Cleaned event-vector pairs");
            ageAgo = ageAgo.add(littleSkip);
            TotalLoserEventCleaner.cleanESP(ageAgo);
            SodDB.getSingleton();
            SodDB.commit();
            logger.info("Cleaned event-station pairs");
            ageAgo = ageAgo.add(littleSkip);
            TotalLoserEventCleaner.cleanENP(ageAgo);
            SodDB.getSingleton();
            SodDB.commit();
            logger.info("Cleaned event-network pairs");
        }
        catch (Throwable e) {
            try {
                StatefulEventDB.getSingleton().rollback();
            }
            catch (Throwable e1) {
                GlobalExceptionHandler.handle((Throwable)e1);
            }
            GlobalExceptionHandler.handle((Throwable)e);
        }
    }

    public static void cleanEvents(MicroSecondDate ageAgo) {
        Query q = StatefulEventDB.getSingleton().getSession().createQuery(" from " + StatefulEvent.class.getName() + " e  where e.status.standingInt = " + Standing.REJECT.getVal() + " and e.preferred.originTime.time < :ageAgo");
        q.setTimestamp("ageAgo", (Date)ageAgo.getTimestamp());
        Iterator it = q.iterate();
        int counter = 0;
        while (it.hasNext()) {
            StatefulEvent se = (StatefulEvent)((Object)it.next());
            StatefulEventDB.getSingleton().getSession().delete((Object)se);
            ++counter;
        }
        StatefulEventDB.getSingleton().commit();
        logger.debug("Done, deleted " + counter + " events.");
    }

    public static void cleanESP(MicroSecondDate ageAgo) {
        TotalLoserEventCleaner.clean(EventStationPair.class, ageAgo);
    }

    public static void cleanENP(MicroSecondDate ageAgo) {
        TotalLoserEventCleaner.clean(EventNetworkPair.class, ageAgo);
    }

    public static void cleanECP(MicroSecondDate ageAgo) {
        TotalLoserEventCleaner.clean(EventChannelPair.class, ageAgo);
    }

    public static void cleanEVP(MicroSecondDate ageAgo) {
        TotalLoserEventCleaner.clean(EventVectorPair.class, ageAgo);
    }

    public static void clean(Class eventPairClass, MicroSecondDate ageAgo) {
        SodDB.getSingleton();
        Query q = SodDB.getSession().createQuery("delete " + eventPairClass.getName() + " ep where ep.status.standingInt = " + Standing.REJECT.getVal() + " and ep.lastQuery < :ageAgo");
        q.setTimestamp("ageAgo", (Date)ageAgo.getTimestamp());
        int deleted = q.executeUpdate();
        SodDB.getSingleton();
        SodDB.commit();
        logger.info("delete " + deleted + " old " + eventPairClass.getName());
    }
}

