/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class RunProperties {
    public static final TimeInterval NO_TIME = new TimeInterval(0.0, UnitImpl.SECOND);
    public static final TimeInterval ONE_WEEK = new TimeInterval(7.0, UnitImpl.DAY);
    public static final TimeInterval TEN_MIN = new TimeInterval(10.0, UnitImpl.MINUTE);
    public static final TimeInterval DAYS_180 = new TimeInterval(180.0, UnitImpl.DAY);
    private TimeInterval eventQueryIncrement = ONE_WEEK;
    private TimeInterval eventLag = ONE_WEEK;
    private TimeInterval eventRefresh = TEN_MIN;
    private TimeInterval maxRetry = DAYS_180;
    private TimeInterval serverRetryDelay = NO_TIME;
    private TimeInterval seismogramLatency = (TimeInterval)ONE_WEEK.multiplyBy(4.0);
    private String runName = "Your Sod";
    private String statusDir = "status";
    private int numWorkers = 1;
    private boolean reopenEvents = false;
    private boolean removeDatabase = false;
    private boolean warnIfDatabaseExists = true;
    private boolean statusPages = false;
    public static final String DONT_RESTART = "noCheck";
    public static final String AT_LEAST_ONCE = "atLeastOnce";
    public static final String AT_MOST_ONCE = "atMostOnce";
    private String evChanPairProc = "atLeastOnce";
    private boolean checkpointPeriodically = false;
    private boolean loserEventCleaner = false;
    private boolean allowDeadNets;
    private String channelGroupingRules = null;
    private boolean skipAvailableData = true;
    private boolean statusWebKeepAlive = false;
    private List hibernateConfig = new ArrayList();

    public void addProperties(Element el) throws ConfigurationException {
        if (el != null) {
            Element hibernateExtraConfig;
            Element chanGroupRuleChild;
            Element evChanPairProcChild;
            Element numWorkersChild;
            Element serverRetryChild;
            Element seismogramLatencyEl;
            Element maxRetryChild;
            Element eventRefreshChild;
            Element eventLagChild;
            Element eventQueryChild;
            Element statusBaseChild;
            Element runNameChild = SodUtil.getElement(el, "runName");
            if (runNameChild != null) {
                this.runName = SodUtil.getText(runNameChild);
            }
            if ((statusBaseChild = SodUtil.getElement(el, "statusBase")) != null) {
                this.statusDir = SodUtil.getText(statusBaseChild);
            }
            if ((eventQueryChild = SodUtil.getElement(el, "eventQueryIncrement")) != null) {
                this.eventQueryIncrement = SodUtil.loadTimeInterval(eventQueryChild);
            }
            if ((eventLagChild = SodUtil.getElement(el, "eventLag")) != null) {
                this.eventLag = SodUtil.loadTimeInterval(eventLagChild);
            }
            if ((eventRefreshChild = SodUtil.getElement(el, "eventRefreshInterval")) != null) {
                this.eventRefresh = SodUtil.loadTimeInterval(eventRefreshChild);
            }
            if ((maxRetryChild = SodUtil.getElement(el, "maxRetryDelay")) != null) {
                this.maxRetry = SodUtil.loadTimeInterval(maxRetryChild);
            }
            if ((seismogramLatencyEl = SodUtil.getElement(el, "seismogramLatency")) != null) {
                this.seismogramLatency = SodUtil.loadTimeInterval(seismogramLatencyEl);
            }
            if ((serverRetryChild = SodUtil.getElement(el, "serverRetryDelay")) != null) {
                this.serverRetryDelay = SodUtil.loadTimeInterval(serverRetryChild);
            }
            if ((numWorkersChild = SodUtil.getElement(el, "waveformWorkerThreads")) != null) {
                this.numWorkers = Integer.parseInt(SodUtil.getText(numWorkersChild));
            }
            if ((evChanPairProcChild = SodUtil.getElement(el, "eventChannelPairProcessing")) != null) {
                this.evChanPairProc = SodUtil.getText(evChanPairProcChild);
            }
            if ((chanGroupRuleChild = SodUtil.getElement(el, "channelGroupingRules")) != null) {
                this.channelGroupingRules = SodUtil.getText(chanGroupRuleChild);
            }
            if (SodUtil.isTrue(el, "reopenEvents", false)) {
                this.reopenEvents = true;
            }
            if (SodUtil.isTrue(el, "removeDatabase", false)) {
                this.removeDatabase = true;
            }
            if (!SodUtil.isTrue(el, "warnIfDatabaseExists", true)) {
                this.warnIfDatabaseExists = false;
            }
            if (SodUtil.isTrue(el, "statusPages", false)) {
                this.statusPages = true;
            }
            if (DOMHelper.hasElement((Element)el, (String)"checkpointPeriodically")) {
                this.checkpointPeriodically = true;
            }
            if (DOMHelper.hasElement((Element)el, (String)"loserEventCleaner")) {
                this.loserEventCleaner = true;
            }
            if (DOMHelper.hasElement((Element)el, (String)"allowNetworksOutsideEventRequestTime")) {
                this.allowDeadNets = true;
            }
            if (DOMHelper.hasElement((Element)el, (String)"skipAvailableData")) {
                this.skipAvailableData = DOMHelper.extractBoolean((Element)el, (String)"skipAvailableData");
            }
            if ((hibernateExtraConfig = SodUtil.getElement(el, "hibernateConfig")) != null) {
                this.hibernateConfig.add(SodUtil.getText(hibernateExtraConfig));
            }
        }
    }

    public TimeInterval getMaxRetryDelay() {
        return this.maxRetry;
    }

    public TimeInterval getServerRetryDelay() {
        return this.serverRetryDelay;
    }

    public TimeInterval getEventQueryIncrement() {
        return this.eventQueryIncrement;
    }

    public TimeInterval getEventLag() {
        return this.eventLag;
    }

    public TimeInterval getEventRefreshInterval() {
        return this.eventRefresh;
    }

    public TimeInterval getSeismogramLatency() {
        return this.seismogramLatency;
    }

    public String getRunName() {
        return this.runName;
    }

    public String getStatusBaseDir() {
        return this.statusDir;
    }

    public int getNumWaveformWorkerThreads() {
        return this.numWorkers;
    }

    public void setNumWaveformWorkerThreads(int numWorkers) {
        this.numWorkers = numWorkers;
    }

    public boolean reopenEvents() {
        return this.reopenEvents;
    }

    public boolean removeDatabase() {
        return this.removeDatabase;
    }

    public boolean warnIfDatabaseExists() {
        return this.warnIfDatabaseExists;
    }

    public String getEventChannelPairProcessing() {
        return this.evChanPairProc;
    }

    public boolean reopenSuspended() {
        return !this.evChanPairProc.equals(DONT_RESTART);
    }

    public boolean doStatusPages() {
        return this.statusPages;
    }

    public boolean checkpointPeriodically() {
        return this.checkpointPeriodically;
    }

    public boolean loserEventCleaner() {
        return this.loserEventCleaner;
    }

    public void setAllowDeadNets(boolean b) {
        this.allowDeadNets = b;
    }

    public boolean allowDeadNets() {
        return this.allowDeadNets;
    }

    public boolean isSkipAvailableData() {
        return this.skipAvailableData;
    }

    public void setSkipAvailableData(boolean skipAvailableData) {
        this.skipAvailableData = skipAvailableData;
    }

    public List getHibernateConfig() {
        return this.hibernateConfig;
    }

    public String getChannelGroupingRules() {
        return this.channelGroupingRules;
    }

    public boolean isStatusWebKeepAlive() {
        return this.statusWebKeepAlive;
    }

    public void setStatusWebKeepAlive(boolean b) {
        this.statusWebKeepAlive = b;
    }
}

