/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import java.sql.Timestamp;
import java.util.Date;

public class QueryTime {
    protected int dbid;
    protected String serverName;
    protected String serverDNS;
    protected Timestamp time;

    public QueryTime() {
    }

    public QueryTime(String serverName, String serverDNS, Timestamp time) {
        this.serverName = serverName;
        this.serverDNS = serverDNS;
        this.time = time;
    }

    public boolean needsRefresh(TimeInterval refreshInterval) {
        MicroSecondDate lastTime = new MicroSecondDate(this.getTime());
        MicroSecondDate currentTime = ClockUtil.now();
        TimeInterval timeInterval = currentTime.difference(lastTime);
        return (timeInterval = (TimeInterval)timeInterval.convertTo(refreshInterval.getUnit())).getValue() >= refreshInterval.getValue();
    }

    public int getDbid() {
        return this.dbid;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerDNS() {
        return this.serverDNS;
    }

    public Timestamp getTime() {
        return this.time;
    }

    protected void setDbid(int dbid) {
        this.dbid = dbid;
    }

    protected void setServerName(String serverName) {
        this.serverName = serverName;
    }

    protected void setServerDNS(String serverDNS) {
        this.serverDNS = serverDNS;
    }

    public void setTime(Timestamp time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (o instanceof QueryTime) {
            QueryTime q = (QueryTime)o;
            return this.getDbid() == q.getDbid() && this.getServerDNS().equals(q.getServerDNS()) && this.getServerName().equals(q.getServerName()) && this.getTime().equals(q.getTime());
        }
        return false;
    }

    public int hashCode() {
        return 89 + 17 * this.getDbid() + 17 * this.getServerDNS().hashCode() + this.getServerName().hashCode() + 17 * this.getTime().hashCode();
    }

    public long delayUntilNextRefresh(TimeInterval refreshInterval) {
        MicroSecondDate now = ClockUtil.now();
        MicroSecondDate nextRefresh = new MicroSecondDate(this.getTime()).add(refreshInterval);
        if (nextRefresh.before((Date)now)) {
            return 0L;
        }
        return (long)nextRefresh.subtract(now).getValue(UnitImpl.MILLISECOND);
    }
}

