/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.sod.CookieEventPair;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.hibernate.StatefulEvent;

public abstract class AbstractEventChannelPair
extends CookieEventPair {
    protected EventStationPair esp;
    private CookieJar cookieJar;

    protected AbstractEventChannelPair() {
    }

    public AbstractEventChannelPair(StatefulEvent event, EventStationPair esp) {
        this(event, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT), esp);
    }

    public AbstractEventChannelPair(StatefulEvent event, Status status, EventStationPair esp) {
        super(event, status);
        this.setEsp(esp);
    }

    @Override
    public void update(Status status) {
        this.setStatus(status);
        this.updateRetries();
        if (Start.getWaveformRecipe() != null) {
            Start.getWaveformRecipe().setStatus(this);
        }
    }

    protected void setEsp(EventStationPair esp) {
        this.esp = esp;
    }

    public EventStationPair getEsp() {
        return this.esp;
    }

    public CookieJar getCookieJar() {
        if (this.cookieJar == null) {
            this.cookieJar = new CookieJar(this, this.getEsp().getCookies(), this.getCookies());
        }
        return this.cookieJar;
    }
}

