/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.CriticalDepth;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SplitLayerInfo;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.VelocityModel;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public class TauModel
implements Serializable {
    public static transient boolean DEBUG = false;
    protected boolean spherical = true;
    protected double sourceDepth = 0.0;
    protected int sourceBranch = 0;
    protected double[] noDisconDepths = new double[0];
    protected double mohoDepth;
    protected int mohoBranch;
    protected double cmbDepth;
    protected int cmbBranch;
    protected double iocbDepth;
    protected int iocbBranch;
    protected double radiusOfEarth = 6371.0;
    private SlownessModel sMod;
    protected double[] rayParams;
    public TauBranch[][] tauBranches = new TauBranch[2][];
    private HashMap<Double, SoftReference<TauModel>> depthCache = new HashMap();

    public TauModel(SlownessModel sMod) throws NoSuchLayerException, NoSuchMatPropException, SlownessModelException, TauModelException {
        this.sMod = sMod;
        this.calcTauIncFrom();
    }

    public TauModel(boolean spherical, double sourceDepth, int sourceBranch, double[] noDisconDepths, double mohoDepth, int mohoBranch, double cmbDepth, int cmbBranch, double iocbDepth, int iocbBranch, double radiusOfEarth, SlownessModel mod, double[] rayParams, TauBranch[][] tauBranches) {
        this.spherical = spherical;
        this.sourceDepth = sourceDepth;
        this.sourceBranch = sourceBranch;
        this.noDisconDepths = noDisconDepths;
        this.mohoDepth = mohoDepth;
        this.mohoBranch = mohoBranch;
        this.cmbDepth = cmbDepth;
        this.cmbBranch = cmbBranch;
        this.iocbDepth = iocbDepth;
        this.iocbBranch = iocbBranch;
        this.radiusOfEarth = radiusOfEarth;
        this.sMod = mod;
        this.rayParams = rayParams;
        this.tauBranches = tauBranches;
    }

    public boolean isSpherical() {
        return this.spherical;
    }

    public String getModelName() {
        return this.sMod.vMod.getModelName();
    }

    public SlownessModel getSlownessModel() {
        return this.sMod;
    }

    public VelocityModel getVelocityModel() {
        return this.sMod.vMod;
    }

    public double getSourceDepth() {
        return this.sourceDepth;
    }

    public int getSourceBranch() {
        return this.sourceBranch;
    }

    public double[] getNoDisconDepths() {
        return this.noDisconDepths;
    }

    public boolean isNoDisconBranch(int branchNum) {
        for (int i = 0; i < this.noDisconDepths.length; ++i) {
            if (this.noDisconDepths[i] != this.getTauBranch(branchNum, true).getTopDepth()) continue;
            return true;
        }
        return false;
    }

    public boolean isNoDisconDepth(double noDisconDepth) {
        for (int i = 0; i < this.noDisconDepths.length; ++i) {
            if (this.noDisconDepths[i] != noDisconDepth) continue;
            return true;
        }
        return false;
    }

    public synchronized void setNoDisconDepths(double[] noDisconDepths) {
        this.noDisconDepths = noDisconDepths;
    }

    public synchronized void appendNoDisconDepth(double noDisconDepth) {
        double[] temp = new double[this.noDisconDepths.length + 1];
        System.arraycopy(this.noDisconDepths, 0, temp, 0, this.noDisconDepths.length);
        this.noDisconDepths = temp;
        this.noDisconDepths[this.noDisconDepths.length - 1] = noDisconDepth;
    }

    public double getMohoDepth() {
        return this.mohoDepth;
    }

    public int getMohoBranch() {
        return this.mohoBranch;
    }

    public double getCmbDepth() {
        return this.cmbDepth;
    }

    public int getCmbBranch() {
        return this.cmbBranch;
    }

    public double getIocbDepth() {
        return this.iocbDepth;
    }

    public int getIocbBranch() {
        return this.iocbBranch;
    }

    public double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public double[] getRayParams() {
        return (double[])this.rayParams.clone();
    }

    public double getOneRayParam(int i) {
        return this.rayParams[i];
    }

    public int getNumBranches() {
        return this.tauBranches[0].length;
    }

    public TauBranch getTauBranch(int branchNum, boolean isPWave) {
        if (isPWave) {
            return this.tauBranches[0][branchNum];
        }
        return this.tauBranches[1][branchNum];
    }

    public double[] getBranchDepths() {
        double[] branchDepths = new double[this.getNumBranches()];
        branchDepths[0] = this.getTauBranch(0, true).getTopDepth();
        for (int i = 1; i < branchDepths.length; ++i) {
            branchDepths[i] = this.getTauBranch(i - 1, true).getBotDepth();
        }
        return branchDepths;
    }

    public double findDepth(double rayParam, boolean isPWave) throws TauModelException {
        try {
            return this.sMod.findDepth(rayParam, isPWave);
        }
        catch (SlownessModelException e) {
            throw new TauModelException("findDepth: caught SlownessModelException:" + e.getMessage());
        }
    }

    private void calcTauIncFrom() throws SlownessModelException, NoSuchLayerException, TauModelException, NoSuchMatPropException {
        if (DEBUG) {
            System.out.println("Size of slowness model: sMod.getNumLayers('P') = " + this.sMod.getNumLayers(true) + ", sMod.getNumLayers('S') = " + this.sMod.getNumLayers(false));
        }
        if (this.sMod.getNumLayers(true) == 0 || this.sMod.getNumLayers(false) == 0) {
            throw new SlownessModelException("Can't calculate tauInc when getNumLayers() = 0. I need more slowness samples.");
        }
        if (!this.sMod.validate()) {
            throw new SlownessModelException("Validation failed: Something is wrong with the slowness model.");
        }
        this.radiusOfEarth = this.sMod.getRadiusOfEarth();
        this.sourceDepth = 0.0;
        this.sourceBranch = 0;
        int numBranches = this.sMod.getNumCriticalDepths() - 1;
        this.tauBranches[0] = new TauBranch[numBranches];
        this.tauBranches[1] = new TauBranch[numBranches];
        int rayNum = 0;
        double minPSoFar = this.sMod.getSlownessLayer(0, false).getTopP();
        double[] tempRayParams = new double[2 * this.sMod.getNumLayers(false) + this.sMod.getNumCriticalDepths()];
        tempRayParams[rayNum] = minPSoFar;
        ++rayNum;
        for (int layerNum = 0; layerNum < this.sMod.getNumLayers(false); ++layerNum) {
            SlownessLayer currSLayer = this.sMod.getSlownessLayer(layerNum, false);
            if (currSLayer.getTopP() < minPSoFar) {
                tempRayParams[rayNum] = currSLayer.getTopP();
                ++rayNum;
                minPSoFar = currSLayer.getTopP();
            }
            if (!(currSLayer.getBotP() < minPSoFar)) continue;
            tempRayParams[rayNum] = currSLayer.getBotP();
            ++rayNum;
            minPSoFar = currSLayer.getBotP();
        }
        this.rayParams = new double[rayNum];
        System.arraycopy(tempRayParams, 0, this.rayParams, 0, rayNum);
        tempRayParams = null;
        if (DEBUG) {
            System.out.println("Number of slowness samples for tau =" + rayNum);
        }
        boolean isPWave = true;
        for (int waveNum = 0; waveNum < 2; ++waveNum) {
            minPSoFar = this.sMod.getSlownessLayer(0, isPWave).getTopP();
            for (int critNum = 0; critNum < this.sMod.getNumCriticalDepths() - 1; ++critNum) {
                CriticalDepth topCritDepth = this.sMod.getCriticalDepth(critNum);
                int topCritLayerNum = topCritDepth.getLayerNum(isPWave);
                CriticalDepth botCritDepth = this.sMod.getCriticalDepth(critNum + 1);
                int botCritLayerNum = botCritDepth.getLayerNum(isPWave) - 1;
                if (DEBUG) {
                    System.out.println("Calculating " + (isPWave ? "P" : "S") + " tau branch for branch " + critNum + " topCritLayerNum=" + topCritLayerNum + " botCritLayerNum=" + botCritLayerNum + "\nminPSoFar=" + minPSoFar);
                }
                this.tauBranches[waveNum][critNum] = new TauBranch(topCritDepth.getDepth(), botCritDepth.getDepth(), isPWave);
                this.tauBranches[waveNum][critNum].DEBUG = DEBUG;
                this.tauBranches[waveNum][critNum].createBranch(this.sMod, minPSoFar, this.rayParams);
                SlownessLayer topSLayer = this.sMod.getSlownessLayer(topCritLayerNum, isPWave);
                SlownessLayer botSLayer = this.sMod.getSlownessLayer(botCritLayerNum, isPWave);
                minPSoFar = Math.min(minPSoFar, Math.min(topSLayer.getTopP(), botSLayer.getBotP()));
                botSLayer = this.sMod.getSlownessLayer(this.sMod.layerNumberAbove(botCritDepth.getDepth(), isPWave), isPWave);
                minPSoFar = Math.min(minPSoFar, botSLayer.getBotP());
            }
            isPWave = false;
        }
        double bestMoho = Double.MAX_VALUE;
        double bestCmb = Double.MAX_VALUE;
        double bestIocb = Double.MAX_VALUE;
        for (int branchNum = 0; branchNum < this.tauBranches[0].length; ++branchNum) {
            TauBranch tBranch = this.tauBranches[0][branchNum];
            if (Math.abs(tBranch.getTopDepth() - this.sMod.vMod.getMohoDepth()) <= bestMoho) {
                this.mohoBranch = branchNum;
                bestMoho = Math.abs(tBranch.getTopDepth() - this.sMod.vMod.getMohoDepth());
            }
            if (Math.abs(tBranch.getTopDepth() - this.sMod.vMod.getCmbDepth()) < bestCmb) {
                this.cmbBranch = branchNum;
                bestCmb = Math.abs(tBranch.getTopDepth() - this.sMod.vMod.getCmbDepth());
            }
            if (!(Math.abs(tBranch.getTopDepth() - this.sMod.vMod.getIocbDepth()) < bestIocb)) continue;
            this.iocbBranch = branchNum;
            bestIocb = Math.abs(tBranch.getTopDepth() - this.sMod.vMod.getIocbDepth());
        }
        this.mohoDepth = this.tauBranches[0][this.mohoBranch].getTopDepth();
        this.cmbDepth = this.tauBranches[0][this.cmbBranch].getTopDepth();
        this.iocbDepth = this.tauBranches[0][this.iocbBranch].getTopDepth();
        if (!this.validate()) {
            throw new TauModelException("calcTauIncFrom: Validation failed!");
        }
    }

    public int findBranch(double depth) throws TauModelException {
        for (int i = 0; i < this.tauBranches[0].length; ++i) {
            if (!(this.tauBranches[0][i].getTopDepth() <= depth) || !(this.tauBranches[0][i].getBotDepth() > depth)) continue;
            return i;
        }
        if (this.tauBranches[0][this.tauBranches[0].length - 1].getBotDepth() == depth) {
            return this.tauBranches[0].length - 1;
        }
        throw new TauModelException("No TauBranch contains depth=" + depth);
    }

    public TauModel depthCorrect(double depth) throws TauModelException {
        if (this.getSourceDepth() != 0.0) {
            throw new TauModelException("depthCorrect: Can't depth correct a tau model that is not for a surface source. Depth=" + this.sourceDepth);
        }
        if (depth > this.getRadiusOfEarth()) {
            throw new TauModelException("depthCorrect: Can't depth correct for a source deeper than the radius of the earth. Depth=" + this.sourceDepth + " radius=" + this.getRadiusOfEarth());
        }
        TauModel depthCorrected = this.loadFromDepthCache(depth);
        if (depthCorrected == null) {
            depthCorrected = this.splitBranch(depth);
            depthCorrected.sourceDepth = depth;
            depthCorrected.sourceBranch = depthCorrected.findBranch(depth);
            depthCorrected.validate();
            this.depthCache.put(depth, new SoftReference<TauModel>(depthCorrected));
        }
        return depthCorrected;
    }

    public TauModel splitBranch(double depth) throws TauModelException {
        try {
            int i;
            for (int branchNum = 0; branchNum < this.tauBranches[0].length; ++branchNum) {
                if (this.tauBranches[0][branchNum].getTopDepth() != depth && this.tauBranches[0][branchNum].getBotDepth() != depth) continue;
                return new TauModel(this.spherical, this.getSourceDepth(), this.getSourceBranch(), this.noDisconDepths, this.mohoDepth, this.mohoBranch, this.cmbDepth, this.cmbBranch, this.iocbDepth, this.iocbBranch, this.radiusOfEarth, this.sMod, this.rayParams, this.tauBranches);
            }
            int indexP = -1;
            double PWaveRayParam = -1.0;
            int indexS = -1;
            double SWaveRayParam = -1.0;
            SlownessModel outSMod = this.sMod;
            double[] outRayParams = this.rayParams;
            boolean isPWave = false;
            for (int waveNum = 1; waveNum >= 0; --waveNum) {
                SplitLayerInfo splitInfo = outSMod.splitLayer(depth, isPWave);
                outSMod = splitInfo.getSlownessModel();
                if (!splitInfo.getMovedSample() && splitInfo.getNeededSplit()) {
                    double newRayParam = splitInfo.getRayParam();
                    int index = -1;
                    for (int i2 = 0; i2 < outRayParams.length - 1 && outRayParams[i2] != newRayParam; ++i2) {
                        if (!(outRayParams[i2] > newRayParam) || !(outRayParams[i2 + 1] < newRayParam)) continue;
                        index = i2 + 1;
                        double[] oldRayParams = outRayParams;
                        outRayParams = new double[oldRayParams.length + 1];
                        System.arraycopy(oldRayParams, 0, outRayParams, 0, index);
                        outRayParams[index] = newRayParam;
                        System.arraycopy(oldRayParams, index, outRayParams, index + 1, oldRayParams.length - index);
                        if (isPWave) {
                            indexP = index;
                            PWaveRayParam = newRayParam;
                            break;
                        }
                        indexS = index;
                        SWaveRayParam = newRayParam;
                        break;
                    }
                }
                isPWave = true;
            }
            int branchToSplit = this.findBranch(depth);
            TauBranch[][] newtauBranches = new TauBranch[2][this.getNumBranches() + 1];
            for (i = 0; i < branchToSplit; ++i) {
                newtauBranches[0][i] = this.tauBranches[0][i].clone();
                newtauBranches[1][i] = this.tauBranches[1][i].clone();
                if (indexS != -1) {
                    newtauBranches[0][i].insert(SWaveRayParam, outSMod, indexS);
                    newtauBranches[1][i].insert(SWaveRayParam, outSMod, indexS);
                }
                if (indexP == -1) continue;
                newtauBranches[0][i].insert(PWaveRayParam, outSMod, indexP);
                newtauBranches[1][i].insert(PWaveRayParam, outSMod, indexP);
            }
            for (int pOrS = 0; pOrS < 2; ++pOrS) {
                newtauBranches[pOrS][branchToSplit] = new TauBranch(this.tauBranches[pOrS][branchToSplit].getTopDepth(), depth, pOrS == 0);
                newtauBranches[pOrS][branchToSplit].createBranch(outSMod, this.tauBranches[pOrS][branchToSplit].getMaxRayParam(), outRayParams);
                newtauBranches[pOrS][branchToSplit + 1] = this.tauBranches[pOrS][branchToSplit].difference(newtauBranches[pOrS][branchToSplit], indexP, indexS, outSMod, newtauBranches[pOrS][branchToSplit].getMinRayParam(), outRayParams);
            }
            for (i = branchToSplit + 1; i < this.tauBranches[0].length; ++i) {
                int pOrS;
                for (pOrS = 0; pOrS < 2; ++pOrS) {
                    newtauBranches[pOrS][i + 1] = this.tauBranches[pOrS][i].clone();
                }
                if (indexS != -1) {
                    for (pOrS = 0; pOrS < 2; ++pOrS) {
                        newtauBranches[pOrS][i + 1].insert(SWaveRayParam, outSMod, indexS);
                    }
                }
                if (indexP == -1) continue;
                for (pOrS = 0; pOrS < 2; ++pOrS) {
                    newtauBranches[pOrS][i + 1].insert(PWaveRayParam, outSMod, indexP);
                }
            }
            int outSourceBranch = this.sourceBranch;
            if (this.sourceDepth > depth) {
                ++outSourceBranch;
            }
            int outMohoBranch = this.mohoBranch;
            if (this.mohoDepth > depth) {
                ++outMohoBranch;
            }
            int outCmbBranch = this.cmbBranch;
            if (this.cmbDepth > depth) {
                ++outCmbBranch;
            }
            int outIocbBranch = this.iocbBranch;
            if (this.iocbDepth > depth) {
                ++outIocbBranch;
            }
            TauModel tMod = new TauModel(this.spherical, this.getSourceDepth(), outSourceBranch, this.noDisconDepths, this.mohoDepth, outMohoBranch, this.cmbDepth, outCmbBranch, this.iocbDepth, outIocbBranch, this.radiusOfEarth, outSMod, outRayParams, newtauBranches);
            tMod.appendNoDisconDepth(depth);
            if (!tMod.validate()) {
                throw new TauModelException("splitBranch(" + depth + "): Validation failed!");
            }
            return tMod;
        }
        catch (NoSuchLayerException e) {
            throw new TauModelException("TauModel.depthCorrect - NoSuchLayerException", e);
        }
        catch (SlownessModelException e) {
            e.printStackTrace();
            throw new TauModelException("TauModel.depthCorrect - SlownessModelException", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeModel(String filename) throws IOException {
        FileOutputStream fOut = new FileOutputStream(filename);
        ObjectOutputStream out = new ObjectOutputStream(fOut);
        try {
            out.writeObject(this);
        }
        finally {
            out.close();
            fOut.close();
        }
    }

    public void writeModelToStream(OutputStream outStream) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(outStream);
        out.writeObject(this);
    }

    public static TauModel readModel(String filename) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        TauModel tMod;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));){
            tMod = TauModel.readModelFromStream(in);
        }
        return tMod;
    }

    public static TauModel readModelFromStream(InputStream inStream) throws InvalidClassException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        ObjectInputStream in = new ObjectInputStream(inStream);
        TauModel tMod = (TauModel)in.readObject();
        return tMod;
    }

    public boolean validate() {
        int i;
        for (i = 0; i < this.rayParams.length - 1; ++i) {
            if (!(this.rayParams[i + 1] >= this.rayParams[i])) continue;
            System.err.println("RayParams are not monotonically decreasing. rayParams[" + i + "]=" + this.rayParams[i] + " rayParams[" + (i + 1) + "]=" + this.rayParams[i + 1]);
            return false;
        }
        if (this.tauBranches[0].length != this.tauBranches[1].length) {
            System.err.println("TauBranches for P and S are not equal. " + this.tauBranches[0].length + " " + this.tauBranches[1].length);
            return false;
        }
        if (this.tauBranches[0][0].getTopDepth() != 0.0 || this.tauBranches[1][0].getTopDepth() != 0.0) {
            System.err.println("branch 0 topDepth != 0");
            return false;
        }
        if (this.tauBranches[1][0].getMaxRayParam() != this.rayParams[0]) {
            System.err.println("branch 0 maxRayParam != rayParams[0]");
            return false;
        }
        for (i = 1; i < this.getNumBranches(); ++i) {
            if (this.tauBranches[0][i].getTopDepth() != this.tauBranches[1][i].getTopDepth()) {
                System.err.println("branch " + i + " P topDepth != S topDepth");
                return false;
            }
            if (this.tauBranches[0][i].getBotDepth() != this.tauBranches[1][i].getBotDepth()) {
                System.err.println("branch " + i + " P botDepth != S botDepth");
                return false;
            }
            if (this.tauBranches[0][i].getTopDepth() != this.tauBranches[0][i - 1].getBotDepth()) {
                System.err.println("branch " + i + " topDepth != botDepth of " + (i - 1));
                return false;
            }
            if (this.tauBranches[0][i].getMaxRayParam() != this.tauBranches[0][i - 1].getMinRayParam()) {
                System.err.println("branch " + i + " P maxRayParam != minRayParam of " + (i - 1) + "\nmaxRayParam=" + this.tauBranches[0][i].getMaxRayParam() + "\nminRayParam=" + this.tauBranches[0][i - 1].getMinRayParam());
                return false;
            }
            if (this.tauBranches[1][i].getMaxRayParam() == this.tauBranches[1][i - 1].getMinRayParam()) continue;
            System.err.println("branch " + i + " S maxRayParam != minRayParam of " + (i - 1) + "\nmaxRayParam=" + this.tauBranches[1][i].getMaxRayParam() + "\nminRayParam=" + this.tauBranches[1][i - 1].getMinRayParam() + "\ndepth = " + this.tauBranches[1][i].getTopDepth());
            return false;
        }
        if (this.tauBranches[0][this.getNumBranches() - 1].getMinRayParam() != 0.0) {
            System.err.println("branch tauBranches[0].length-1 minRayParam != 0");
            return false;
        }
        if (this.tauBranches[1][this.getNumBranches() - 1].getMinRayParam() != 0.0) {
            System.err.println("branch tauBranches[1].length-1 minRayParam != 0");
            return false;
        }
        return true;
    }

    public void print() {
        if (DEBUG) {
            System.out.println("Starting print() in TauModel");
        }
        System.out.println("Delta tau for each slowness sample and layer.");
        for (int j = 0; j < this.rayParams.length; ++j) {
            double deg = 0.0;
            double time = 0.0;
            for (int i = 0; i < this.getNumBranches(); ++i) {
                deg += this.tauBranches[0][i].getDist(j) * 180.0 / Math.PI;
                time += this.tauBranches[0][i].time[j];
                System.out.println(" i " + i + " j " + j + " rayParam " + this.rayParams[j] + " tau " + this.tauBranches[0][i].tau[j] + " time " + this.tauBranches[0][i].time[j] + " dist " + this.tauBranches[0][i].getDist(j) + " degrees " + this.tauBranches[0][i].getDist(j) * 180.0 / Math.PI);
            }
            System.out.println();
            System.out.println("deg= " + deg + "  time=" + time);
        }
    }

    public String toString() {
        if (DEBUG) {
            System.out.println("Starting toString() in TauModel");
        }
        String desc = "Delta tau for each slowness sample and layer.\n";
        for (int j = 0; j < this.rayParams.length; ++j) {
            for (int i = 0; i < this.tauBranches[0].length; ++i) {
                desc = desc + " i " + i + " j " + j + " rayParam " + this.rayParams[j] + " tau " + this.tauBranches[0][i].tau[j] + " time " + this.tauBranches[0][i].time[j] + " dist " + this.tauBranches[0][i].getDist(j) + " degrees " + this.tauBranches[0][i].getDist(j) * 180.0 / Math.PI + "\n";
            }
            desc = desc + "\n";
        }
        return desc;
    }

    protected TauModel loadFromDepthCache(Double depth) {
        SoftReference<TauModel> sr = this.depthCache.get(depth);
        if (sr != null) {
            TauModel out = sr.get();
            if (out == null) {
                this.depthCache.remove(depth);
            }
            return out;
        }
        return null;
    }
}

