/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public class PhaseDialog
extends JDialog {
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel jLabel2;
    private JTextField addPhaseTextField;
    private JButton closeButton;
    private JScrollPane jScrollPane1;
    private JList phaseList;
    private DefaultListModel phaseListModel;

    public PhaseDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.phaseListModel = new DefaultListModel();
        this.phaseList.setModel(this.phaseListModel);
        this.pack();
    }

    private void initComponents() {
        this.setBackground(new Color(192, 192, 192));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PhaseDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Choose Phases");
        this.jLabel1.setHorizontalAlignment(0);
        this.getContentPane().add((Component)this.jLabel1, "North");
        this.jPanel1 = new JPanel();
        this.jPanel1.setLayout(new FlowLayout());
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("Add new");
        this.jPanel1.add(this.jLabel2);
        this.addPhaseTextField = new JTextField();
        this.addPhaseTextField.setPreferredSize(new Dimension(100, 21));
        this.addPhaseTextField.setMinimumSize(new Dimension(100, 21));
        this.addPhaseTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhaseDialog.this.addPhaseActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.addPhaseTextField);
        this.closeButton = new JButton();
        this.closeButton.setText("Close");
        this.closeButton.setActionCommand("ClosePhaseDialog");
        this.closeButton.setLabel("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhaseDialog.this.closeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.closeButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2 = new JPanel();
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1 = new JScrollPane();
        this.phaseList = new JList();
        this.phaseList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                PhaseDialog.this.phaseListKeyTyped(evt);
            }
        });
        this.jScrollPane1.add(this.phaseList);
        this.jScrollPane1.setViewportView(this.phaseList);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "Center");
    }

    private void phaseListKeyTyped(KeyEvent evt) {
        String areaText = this.addPhaseTextField.getText();
        if (evt.getKeyChar() != '\n') {
            areaText = areaText + evt.getKeyChar();
            this.addPhaseTextField.setText(areaText);
        } else {
            this.addPhaseActionPerformed(new ActionEvent(this, 0, areaText));
        }
    }

    private void addPhaseActionPerformed(ActionEvent evt) {
        this.phaseListModel.addElement(evt.getActionCommand());
        ListSelectionModel sel = this.phaseList.getSelectionModel();
        sel.addSelectionInterval(this.phaseListModel.getSize() - 1, this.phaseListModel.getSize() - 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhaseDialog.this.phaseList.ensureIndexIsVisible(PhaseDialog.this.phaseListModel.getSize() - 1);
            }
        });
    }

    private void closeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public String[] getPhases() {
        int[] selected = this.phaseList.getSelectedIndices();
        String[] phases = new String[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            phases[i] = (String)this.phaseListModel.elementAt(selected[i]);
        }
        return phases;
    }

    public void setPhases(String[] phases) {
        this.phaseListModel.removeAllElements();
        for (int i = 0; i < phases.length; ++i) {
            this.phaseListModel.addElement(phases[i]);
        }
        ListSelectionModel sel = this.phaseList.getSelectionModel();
        sel.addSelectionInterval(0, this.phaseListModel.getSize() - 1);
    }

    public void setSelectedPhases(String[] phases) {
        ListSelectionModel sel = this.phaseList.getSelectionModel();
        sel.clearSelection();
        for (int i = 0; i < phases.length; ++i) {
            for (int j = 0; j < this.phaseListModel.size(); ++j) {
                if (!phases[i].equals(this.phaseListModel.elementAt(j))) continue;
                sel.addSelectionInterval(j, j);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(20);
        new PhaseDialog(new Frame(), false).show();
    }
}

