/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.text.Format;
import java.text.NumberFormat;

public class LabelPointRenderer
extends DefaultPointRenderer2D {
    private static final long serialVersionUID = -2612520977245369774L;
    public static final Key COLUMN = new Key("labelPoint.column");
    public static final Key FORMAT = new Key("labelPoint.format");
    public static final Key FONT = new Key("labelPoint.font");
    public static final Key ALIGNMENT_X = new Key("labelPoint.alignment.x");
    public static final Key ALIGNMENT_Y = new Key("labelPoint.alignment.y");

    public LabelPointRenderer() {
        this.setSettingDefault(COLUMN, 1);
        this.setSettingDefault(FORMAT, NumberFormat.getInstance());
        this.setSettingDefault(FONT, Font.decode(null));
        this.setSettingDefault(ALIGNMENT_X, 0.5);
        this.setSettingDefault(ALIGNMENT_Y, 0.5);
    }

    public Shape getPointShape(PointData object) {
        object = ((PointData)object).row;
        int n = ((Number)this.getSetting(COLUMN)).intValue();
        if (n >= ((Row)object).size()) {
            return null;
        }
        if ((object = ((Row)object).get(n)) == null) {
            return null;
        }
        Cloneable cloneable = (Format)this.getSetting(FORMAT);
        Font font = (Font)this.getSetting(FONT);
        object = ((Format)cloneable).format(object);
        double d = ((Number)this.getSetting(ALIGNMENT_X)).doubleValue();
        object = GraphicsUtils.getOutline((String)object, font, 0.0f, d);
        double d2 = ((Number)this.getSetting(ALIGNMENT_X)).doubleValue();
        double d3 = ((Number)this.getSetting(ALIGNMENT_Y)).doubleValue();
        cloneable = object.getBounds2D();
        return AffineTransform.getTranslateInstance(-d2 * ((RectangularShape)cloneable).getWidth(), d3 * ((RectangularShape)cloneable).getHeight()).createTransformedShape((Shape)object);
    }
}

