/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.data.DataAccessor;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawableContainer;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.OuterEdgeLayout;
import de.erichseifert.gral.plots.Label;
import de.erichseifert.gral.plots.StylableDrawable;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Location;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.PointND;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.text.NumberFormat;

public class DefaultPointRenderer2D
extends AbstractPointRenderer {
    private static final long serialVersionUID = -895832597380598383L;

    public Drawable getPoint(PointData pointData, Shape shape) {
        return new AbstractDrawable(this, pointData, shape){
            private static final long serialVersionUID = 1915778739867091906L;
            private /* synthetic */ PointData a;
            private /* synthetic */ Shape b;
            private /* synthetic */ DefaultPointRenderer2D c;
            {
                this.c = defaultPointRenderer2D;
                this.a = pointData;
                this.b = shape;
            }

            public final void draw(DrawingContext drawingContext) {
                DefaultPointRenderer2D defaultPointRenderer2D = this.c;
                Axis axis = this.a.axes.get(1);
                AxisRenderer axisRenderer = this.a.axisRenderers.get(1);
                Row row = this.a.row;
                int n = this.a.col;
                Paint paint = ((ColorMapper)defaultPointRenderer2D.getSetting(PointRenderer.COLOR)).get(row.getIndex());
                GraphicsUtils.fillPaintedShape(drawingContext.getGraphics(), this.b, paint, null);
                if (((Boolean)defaultPointRenderer2D.getSetting(PointRenderer.ERROR_DISPLAYED)).booleanValue()) {
                    int n2 = (Integer)defaultPointRenderer2D.getSetting(PointRenderer.ERROR_COLUMN_TOP);
                    int n3 = (Integer)defaultPointRenderer2D.getSetting(PointRenderer.ERROR_COLUMN_BOTTOM);
                    this.c.drawErrorBars(drawingContext, this.b, row, n, n2, n3, axis, axisRenderer);
                }
            }
        };
    }

    protected void drawValueLabel(DrawingContext drawingContext, Shape shape, Row object, int n) {
        Object object2 = ((Row)object).get(n);
        Object object3 = (Format)this.getSetting(VALUE_FORMAT);
        if (object3 == null && ((Row)object).isColumnNumeric(n)) {
            object3 = NumberFormat.getInstance();
        }
        Object object4 = object3 != null ? object3.format(object2) : object2.toString();
        object = ((ColorMapper)this.getSetting(VALUE_COLOR)).get(((DataAccessor)object).getIndex());
        object2 = (Font)this.getSetting(VALUE_FONT);
        double d = ((Font)object2).getSize2D();
        object3 = (Location)((Object)this.getSetting(VALUE_LOCATION));
        Number number = (Number)this.getSetting(VALUE_ALIGNMENT_X);
        Number number2 = (Number)this.getSetting(VALUE_ALIGNMENT_Y);
        Number number3 = (Number)this.getSetting(VALUE_ROTATION);
        double d2 = DataUtils.getValueOrDefault((Number)this.getSetting(VALUE_DISTANCE), Double.NaN);
        d2 = MathUtils.isCalculatable(d2) ? (d2 *= d) : 0.0;
        object4 = new Label((String)object4);
        ((StylableDrawable)object4).setSetting(Label.ALIGNMENT_X, number);
        ((StylableDrawable)object4).setSetting(Label.ALIGNMENT_Y, number2);
        ((StylableDrawable)object4).setSetting(Label.ROTATION, number3);
        ((StylableDrawable)object4).setSetting(Label.COLOR, object);
        ((StylableDrawable)object4).setSetting(Label.FONT, object2);
        shape = shape.getBounds2D();
        object = new DrawableContainer(new OuterEdgeLayout(d2));
        ((DrawableContainer)object).add((Drawable)object4, object3);
        ((DrawableContainer)object).setBounds((Rectangle2D)shape);
        ((DrawableContainer)object).draw(drawingContext);
    }

    protected void drawErrorBars(DrawingContext object, Shape object2, Row object3, int n, int n2, int n3, Axis axis, AxisRenderer axisRenderer) {
        if (axisRenderer == null) {
            return;
        }
        if (n2 < 0 || n2 >= ((Row)object3).size() || !((Row)object3).isColumnNumeric(n2) || n3 < 0 || n3 >= ((Row)object3).size() || !((Row)object3).isColumnNumeric(n3)) {
            return;
        }
        object2 = (Number)((Object)((Row)object3).get(n));
        Object object4 = (Number)((Object)((Row)object3).get(n2));
        Number number = (Number)((Object)((Row)object3).get(n3));
        if (!(MathUtils.isCalculatable((Number)object2) && MathUtils.isCalculatable((Number)object4) && MathUtils.isCalculatable(number))) {
            return;
        }
        object = ((DrawingContext)object).getGraphics();
        AffineTransform affineTransform = ((Graphics2D)object).getTransform();
        PointND<Double> pointND = axisRenderer.getPosition(axis, (Number)object2, true, false);
        object4 = axisRenderer.getPosition(axis, ((Number)object2).doubleValue() + ((Number)object4).doubleValue(), true, false);
        object2 = axisRenderer.getPosition(axis, ((Number)object2).doubleValue() - number.doubleValue(), true, false);
        if (pointND == null || object4 == null || object2 == null) {
            return;
        }
        double d = pointND.get(1);
        double d2 = (Double)((PointND)object4).get(1) - d;
        double d3 = ((PointND)object2).get(1) - d;
        object2 = new Line2D.Double(0.0, d2, 0.0, d3);
        object3 = ((ColorMapper)this.getSetting(ERROR_COLOR)).get(((DataAccessor)object3).getIndex());
        object4 = (Stroke)this.getSetting(ERROR_STROKE);
        GraphicsUtils.drawPaintedShape((Graphics2D)object, object2, (Paint)object3, null, (Stroke)object4);
        object2 = (Shape)this.getSetting(ERROR_SHAPE);
        ((Graphics2D)object).translate(0.0, d2);
        object4 = new BasicStroke(1.0f);
        GraphicsUtils.drawPaintedShape((Graphics2D)object, (Shape)object2, (Paint)object3, null, (Stroke)object4);
        ((Graphics2D)object).setTransform(affineTransform);
        ((Graphics2D)object).translate(0.0, d3);
        GraphicsUtils.drawPaintedShape((Graphics2D)object, (Shape)object2, (Paint)object3, null, (Stroke)object4);
        ((Graphics2D)object).setTransform(affineTransform);
    }

    public Shape getPointShape(PointData pointData) {
        return (Shape)this.getSetting(SHAPE);
    }

    public Drawable getValue(PointData pointData, Shape shape) {
        return new AbstractDrawable(this, pointData, shape){
            private static final long serialVersionUID = -2568531344817590175L;
            private /* synthetic */ PointData a;
            private /* synthetic */ Shape b;
            private /* synthetic */ DefaultPointRenderer2D c;
            {
                this.c = defaultPointRenderer2D;
                this.a = pointData;
                this.b = shape;
            }

            public final void draw(DrawingContext drawingContext) {
                DefaultPointRenderer2D defaultPointRenderer2D = this.c;
                Row row = this.a.row;
                if (((Boolean)defaultPointRenderer2D.getSetting(PointRenderer.VALUE_DISPLAYED)).booleanValue()) {
                    int n = (Integer)defaultPointRenderer2D.getSetting(PointRenderer.VALUE_COLUMN);
                    this.c.drawValueLabel(drawingContext, this.b, row, n);
                }
            }
        };
    }
}

