/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.plots.colors.SingleColor;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.plots.settings.BasicSettingsStorage;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.plots.settings.SettingChangeEvent;
import de.erichseifert.gral.plots.settings.SettingsListener;
import de.erichseifert.gral.util.Location;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPointRenderer
extends BasicSettingsStorage
implements PointRenderer,
SettingsListener {
    private static final long serialVersionUID = -408976260196287753L;

    public AbstractPointRenderer() {
        this.addSettingsListener(this);
        this.setSettingDefault(SHAPE, new Rectangle2D.Double(-2.5, -2.5, 5.0, 5.0));
        this.setSettingDefault(COLOR, new SingleColor(Color.BLACK));
        this.setSettingDefault(VALUE_DISPLAYED, Boolean.FALSE);
        this.setSettingDefault(VALUE_COLUMN, 1);
        this.setSettingDefault(VALUE_LOCATION, Location.CENTER);
        this.setSettingDefault(VALUE_ALIGNMENT_X, 0.5);
        this.setSettingDefault(VALUE_ALIGNMENT_Y, 0.5);
        this.setSettingDefault(VALUE_ROTATION, 0.0);
        this.setSettingDefault(VALUE_DISTANCE, 1.0);
        this.setSettingDefault(VALUE_COLOR, new SingleColor(Color.BLACK));
        this.setSettingDefault(VALUE_FONT, Font.decode(null));
        this.setSettingDefault(ERROR_DISPLAYED, Boolean.FALSE);
        this.setSettingDefault(ERROR_COLUMN_TOP, 2);
        this.setSettingDefault(ERROR_COLUMN_BOTTOM, 3);
        this.setSettingDefault(ERROR_COLOR, new SingleColor(Color.BLACK));
        this.setSettingDefault(ERROR_SHAPE, new Line2D.Double(-2.0, 0.0, 2.0, 0.0));
        this.setSettingDefault(ERROR_STROKE, new BasicStroke(1.0f));
    }

    @Override
    public void settingChanged(SettingChangeEvent settingChangeEvent) {
    }

    @Override
    protected <T> void setSetting(Key key, T t, boolean bl) {
        if (t instanceof Paint && (COLOR.equals(key) || VALUE_COLOR.equals(key) || ERROR_COLOR.equals(key))) {
            super.setSetting(key, new SingleColor((Paint)t), bl);
            return;
        }
        super.setSetting(key, t, bl);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.addSettingsListener(this);
    }
}

