/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.navigation;

import de.erichseifert.gral.navigation.NavigationDirection;
import de.erichseifert.gral.navigation.NavigationEvent;
import de.erichseifert.gral.navigation.NavigationListener;
import de.erichseifert.gral.navigation.Navigator;
import de.erichseifert.gral.util.PointND;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNavigator
implements Navigator {
    public static final double DEFAULT_ZOOM_FACTOR = 1.25;
    public static final double DEFAULT_ZOOM_MIN = 0.01;
    public static final double DEFAULT_ZOOM_MAX = 100.0;
    private final Set<NavigationListener> a = new HashSet<NavigationListener>();
    private double b = 1.25;
    private double c = 0.01;
    private double d = 100.0;
    private boolean e = true;
    private boolean f = true;
    private NavigationDirection g;

    @Override
    public boolean isZoomable() {
        return this.e;
    }

    @Override
    public void setZoomable(boolean bl) {
        this.e = bl;
    }

    @Override
    public void zoomIn() {
        if (!this.isZoomable()) {
            return;
        }
        double d = this.getZoom();
        this.setZoom(d * this.getZoomFactor());
    }

    @Override
    public void zoomOut() {
        if (!this.isZoomable()) {
            return;
        }
        double d = this.getZoom();
        this.setZoom(d / this.getZoomFactor());
    }

    @Override
    public boolean isPannable() {
        return this.f;
    }

    @Override
    public void setPannable(boolean bl) {
        this.f = bl;
    }

    @Override
    public double getZoomFactor() {
        return this.b;
    }

    @Override
    public void setZoomFactor(double d) {
        this.b = d;
    }

    @Override
    public double getZoomMin() {
        return this.c;
    }

    @Override
    public void setZoomMin(double d) {
        this.c = d;
    }

    @Override
    public double getZoomMax() {
        return this.d;
    }

    @Override
    public void setZoomMax(double d) {
        this.d = d;
    }

    @Override
    public void addNavigationListener(NavigationListener navigationListener) {
        this.a.add(navigationListener);
    }

    @Override
    public void removeNavigationListener(NavigationListener navigationListener) {
        this.a.remove(navigationListener);
    }

    @Override
    public NavigationDirection getDirection() {
        return this.g;
    }

    @Override
    public void setDirection(NavigationDirection navigationDirection) {
        this.g = navigationDirection;
    }

    @Override
    public void connect(Navigator navigator) {
        if (navigator != null && navigator != this) {
            this.addNavigationListener(navigator);
            navigator.addNavigationListener(this);
        }
    }

    @Override
    public void disconnect(Navigator navigator) {
        if (navigator != null && navigator != this) {
            this.removeNavigationListener(navigator);
            navigator.removeNavigationListener(this);
        }
    }

    @Override
    public void centerChanged(NavigationEvent<PointND<? extends Number>> navigationEvent) {
        if (navigationEvent.getSource() != this) {
            this.setCenter(navigationEvent.getValueNew());
        }
    }

    @Override
    public void zoomChanged(NavigationEvent<Double> navigationEvent) {
        if (navigationEvent.getSource() != this) {
            this.setZoom(navigationEvent.getValueNew());
        }
    }

    protected void fireCenterChanged(NavigationEvent<PointND<? extends Number>> navigationEvent) {
        Iterator<NavigationListener> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            iterator.next().centerChanged(navigationEvent);
        }
    }

    protected void fireZoomChanged(NavigationEvent<Double> navigationEvent) {
        Iterator<NavigationListener> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            iterator.next().zoomChanged(navigationEvent);
        }
    }
}

