/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.graphics;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Layout;
import de.erichseifert.gral.util.Insets2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawableContainer
extends AbstractDrawable
implements Container {
    private static final long serialVersionUID = 3741045651357559308L;
    private final Insets2D a = new Insets2D.Double();
    private Layout b;
    private final List<Drawable> c = new LinkedList<Drawable>();
    private final Map<Drawable, Object> d = new HashMap<Drawable, Object>();

    public DrawableContainer() {
        this(null);
    }

    public DrawableContainer(Layout layout) {
        this.b = layout;
    }

    @Override
    public void draw(DrawingContext drawingContext) {
        this.drawComponents(drawingContext);
    }

    protected void drawComponents(DrawingContext drawingContext) {
        Iterator<Drawable> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().draw(drawingContext);
        }
    }

    @Override
    public void add(Drawable drawable) {
        this.add(drawable, null);
    }

    @Override
    public void add(Drawable drawable, Object object) {
        if (drawable == this) {
            throw new IllegalArgumentException("A container cannot be added to itself.");
        }
        this.c.add(drawable);
        this.d.put(drawable, object);
        this.layout();
    }

    @Override
    public Drawable getDrawableAt(Point2D point2D) {
        Drawable drawable = null;
        for (Drawable drawable2 : this.c) {
            if (drawable2 == null || !drawable2.getBounds().contains(point2D)) continue;
            drawable = drawable2;
        }
        return drawable;
    }

    @Override
    public Object getConstraints(Drawable drawable) {
        return this.d.get(drawable);
    }

    @Override
    public void remove(Drawable drawable) {
        this.c.remove(drawable);
        this.d.remove(drawable);
        this.layout();
    }

    @Override
    public Insets2D getInsets() {
        Insets2D.Double double_ = new Insets2D.Double();
        ((Insets2D)double_).setInsets(this.a);
        return double_;
    }

    @Override
    public void setInsets(Insets2D insets2D) {
        if (insets2D == this.a || this.a.equals(insets2D)) {
            return;
        }
        this.a.setInsets(insets2D);
        this.layout();
    }

    @Override
    public Layout getLayout() {
        return this.b;
    }

    @Override
    public void setLayout(Layout layout) {
        this.b = layout;
        this.layout();
    }

    @Override
    public void layout() {
        if (this.getLayout() != null) {
            this.getLayout().layout(this);
        }
    }

    @Override
    public Iterator<Drawable> iterator() {
        return this.c.iterator();
    }

    @Override
    public int size() {
        return this.c.size();
    }

    @Override
    public void setBounds(Rectangle2D rectangle2D) {
        super.setBounds(rectangle2D);
        this.layout();
    }

    @Override
    public void setBounds(double d, double d2, double d3, double d4) {
        super.setBounds(d, d2, d3, d4);
        this.layout();
    }

    @Override
    public Dimension2D getPreferredSize() {
        if (this.getLayout() != null) {
            return this.getLayout().getPreferredSize(this);
        }
        return super.getPreferredSize();
    }
}

