/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.IfNetwork;

import edu.iris.Fissures.IfNetwork.NetworkAttrHelper;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkIdHelper;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.TimeRangeHelper;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;

public abstract class NetworkAttr
implements StreamableValue {
    protected NetworkId id;
    private String name;
    private String description;
    private String owner;
    private TimeRange effective_time;
    private static String[] _OB_truncatableIds_ = new String[]{NetworkAttrHelper.id()};
    private static Map<String, WeakReference<Time>> knownTimes = Collections.synchronizedMap(new HashMap());
    private static Map<String, WeakReference<NetworkAttr>> knownNetworks = Collections.synchronizedMap(new HashMap());

    public abstract NetworkId get_id();

    public abstract String get_code();

    public String[] _truncatable_ids() {
        return _OB_truncatableIds_;
    }

    public void _read(InputStream in) {
        this.id = NetworkIdHelper.read(in);
        this.setName(in.read_string());
        this.setDescription(in.read_string());
        this.setOwner(in.read_string());
        this.setEffectiveTime(TimeRangeHelper.read(in));
    }

    public void _write(OutputStream out) {
        NetworkIdHelper.write(out, this.id);
        out.write_string(this.getName());
        out.write_string(this.getDescription());
        out.write_string(this.getOwner());
        TimeRangeHelper.write(out, this.getEffectiveTime());
    }

    public TypeCode _type() {
        return NetworkAttrHelper.type();
    }

    public String getName() {
        return this.name;
    }

    public TimeRange getEffectiveTime() {
        return this.effective_time;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDescription() {
        return this.description;
    }

    public NetworkId getId() {
        return this.get_id();
    }

    public void setId(NetworkId netId) {
        this.id = netId;
        this.setBeginTime(netId.begin_time);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Time getBeginTime() {
        return this.get_id().begin_time;
    }

    public void setBeginTime(Time beginTime) {
        if (this.getEffectiveTime() == null) {
            this.setEffectiveTime(new TimeRange());
        }
        this.getEffectiveTime().start_time = beginTime;
        this.get_id().begin_time = beginTime;
    }

    public Time getEndTime() {
        return this.getEffectiveTime().end_time;
    }

    public void setEndTime(Time endTime) {
        if (this.getEffectiveTime() == null) {
            this.setEffectiveTime(new TimeRange());
        }
        this.getEffectiveTime().end_time = endTime;
        this.getEffectiveTime().start_time = this.get_id().begin_time;
    }

    public static String intern(String s) {
        if (s != null) {
            return s.intern();
        }
        return "".intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkAttr intern(NetworkAttr attr) {
        Map<String, WeakReference<Time>> map = knownTimes;
        synchronized (map) {
            String key = attr.getId().network_code + attr.getId().begin_time.date_time;
            NetworkAttr interned = null;
            if (knownNetworks.containsKey(key)) {
                interned = (NetworkAttr)knownNetworks.get(key).get();
            }
            if (interned == null) {
                knownNetworks.put(key, new WeakReference<NetworkAttr>(attr));
                attr.setDescription(NetworkAttr.intern(attr.getDescription()));
                attr.setName(NetworkAttr.intern(attr.getName()));
                attr.setOwner(NetworkAttr.intern(attr.getOwner()));
                NetworkAttr.intern(attr.get_id());
                return attr;
            }
            return interned;
        }
    }

    public static NetworkId intern(NetworkId id) {
        id.begin_time = NetworkAttr.intern(id.begin_time);
        id.network_code = id.network_code.intern();
        return id;
    }

    public static TimeRange intern(TimeRange effective_time) {
        effective_time.end_time = NetworkAttr.intern(effective_time.end_time);
        effective_time.start_time = NetworkAttr.intern(effective_time.start_time);
        return effective_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time intern(Time unknownTime) {
        Map<String, WeakReference<Time>> map = knownTimes;
        synchronized (map) {
            String key = unknownTime.date_time;
            Time interned = null;
            if (knownTimes.containsKey(key)) {
                interned = (Time)knownTimes.get(key).get();
            }
            if (interned == null) {
                knownTimes.put(key, new WeakReference<Time>(unknownTime));
                return unknownTime;
            }
            return interned;
        }
    }

    protected void setEffectiveTime(TimeRange effective_time) {
        this.effective_time = effective_time;
    }
}

