/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.lw3d.LwoParser;
import com.sun.j3d.loaders.lw3d.LwoSurface;
import com.sun.j3d.loaders.lw3d.LwoTexture;
import com.sun.j3d.loaders.lw3d.ShapeHolder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

class J3dLwoParser
extends LwoParser {
    float[] normalCoordsArray;
    int[] normalIndicesArray;
    Shape3D objectShape;
    Color3f color;
    Color3f diffuseColor;
    Color3f specularColor;
    Color3f emissiveColor;
    float shininess;
    Vector objectShapeList = new Vector();

    J3dLwoParser(String string, int n) throws FileNotFoundException {
        super(string, n);
    }

    J3dLwoParser(URL uRL, int n) throws FileNotFoundException {
        super(uRL, n);
    }

    void getSurf(int n) throws FileNotFoundException {
        super.getSurf(n);
    }

    void createJava3dGeometry() throws IncorrectFormatException {
        Enumeration enumeration = this.shapeList.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            PointArray pointArray;
            Object object2;
            LwoSurface lwoSurface;
            int n = 1;
            ShapeHolder shapeHolder = (ShapeHolder)enumeration.nextElement();
            this.debugOutputLn(8, "about to create Arrays for Shape");
            this.debugOutputLn(2, "shape = " + shapeHolder);
            shapeHolder.createArrays(true);
            int n2 = shapeHolder.coordsArray.length / 3;
            int n3 = 0;
            if (shapeHolder.facetIndices != null) {
                n3 = shapeHolder.facetIndices.length;
            }
            this.debugOutputLn(2, "numSurf = " + shapeHolder.numSurf);
            String string = (String)this.surfNameList.elementAt(shapeHolder.numSurf - 1);
            LwoSurface lwoSurface2 = null;
            int n4 = 0;
            while (n4 < this.surfaceList.size()) {
                lwoSurface = (LwoSurface)this.surfaceList.elementAt(n4);
                object2 = lwoSurface.surfName;
                if (string.equals(object2)) {
                    lwoSurface2 = lwoSurface;
                    break;
                }
                ++n4;
            }
            if (lwoSurface2 == null) {
                throw new IncorrectFormatException("bad surf for surfnum/name = " + shapeHolder.numSurf + ", " + string);
            }
            this.debugOutputLn(2, "surf = " + lwoSurface2);
            LwoTexture lwoTexture = lwoSurface2.getTexture();
            lwoSurface = new Appearance();
            if (shapeHolder.facetSizes[0] == 1) {
                pointArray = new PointArray(n2, n);
                pointArray.setCoordinates(0, shapeHolder.coordsArray);
                object2 = new ColoringAttributes(lwoSurface2.getColor(), 0);
                object = new PointAttributes();
                object.setPointSize(1.0f);
                lwoSurface.setColoringAttributes((ColoringAttributes)object2);
                lwoSurface.setPointAttributes((PointAttributes)object);
            } else if (shapeHolder.facetSizes[0] == 2) {
                this.debugOutputLn(8, "Creating IndexedLineArray");
                pointArray = new LineArray(n2, n);
                pointArray.setCoordinates(0, shapeHolder.coordsArray);
                object2 = new ColoringAttributes(lwoSurface2.getColor(), 0);
                lwoSurface.setColoringAttributes((ColoringAttributes)object2);
            } else {
                GeometryInfo geometryInfo;
                this.debugOutputLn(8, "Creating IndexedTriFanArray");
                n |= 2;
                this.debugOutputLn(8, "about to process vertices/indices, facetIndices = " + shapeHolder.facetIndices);
                if (shapeHolder.facetIndices != null) {
                    object2 = null;
                    object = null;
                    this.debugOutputLn(8, "setting vertexCount, normind = " + shapeHolder.normalIndices);
                    this.debugOutputLn(8, "vtxcount, format, indcount = " + n2 + ", " + n + ", " + n3);
                    if (lwoTexture != null) {
                        n |= 0x20;
                        object2 = new float[n2 * 2];
                        object = new int[shapeHolder.facetIndices.length];
                        this.calculateTextureCoords(lwoTexture, shapeHolder.coordsArray, shapeHolder.facetIndices, (float[])object2, (int[])object);
                        this.debugOutputLn(8, "textureCoords:");
                        this.debugOutputLn(8, "texture Coords, Indices.length = " + ((Object)object2).length + ", " + ((PointAttributes)object).length);
                    }
                    this.debugOutputLn(8, "about to create GeometryInfo");
                    geometryInfo = new GeometryInfo(3);
                    geometryInfo.setCoordinates(shapeHolder.coordsArray);
                    geometryInfo.setCoordinateIndices(shapeHolder.facetIndices);
                    geometryInfo.setStripCounts(shapeHolder.facetSizes);
                    if (lwoTexture != null) {
                        geometryInfo.setTextureCoordinateParams(1, 2);
                        geometryInfo.setTextureCoordinates(0, (float[])object2);
                        geometryInfo.setTextureCoordinateIndices(0, (int[])object);
                    }
                    geometryInfo.recomputeIndices();
                    NormalGenerator normalGenerator = new NormalGenerator(lwoSurface2.getCreaseAngle());
                    normalGenerator.generateNormals(geometryInfo);
                    Stripifier stripifier = new Stripifier();
                    stripifier.stripify(geometryInfo);
                    pointArray = geometryInfo.getGeometryArray(true, true, false);
                    this.debugOutputLn(8, "done.");
                } else {
                    this.debugOutputLn(8, "about to create trifanarray with vertexCount, facetSizes.len = " + n2 + ", " + shapeHolder.facetSizes.length);
                    pointArray = new TriangleFanArray(n2, n, shapeHolder.facetSizes);
                    pointArray.setCoordinates(0, shapeHolder.coordsArray);
                    pointArray.setNormals(0, shapeHolder.normalCoords);
                    this.debugOutputLn(2, "passed in normalCoords, length = " + shapeHolder.normalCoords.length);
                }
                this.debugOutputLn(8, "created fan array");
                object2 = new Material(lwoSurface2.getColor(), lwoSurface2.getEmissiveColor(), lwoSurface2.getDiffuseColor(), lwoSurface2.getSpecularColor(), lwoSurface2.getShininess());
                object2.setLightingEnable(true);
                lwoSurface.setMaterial((Material)object2);
                if (lwoSurface2.getTransparency() != 0.0f) {
                    object = new TransparencyAttributes();
                    object.setTransparency(lwoSurface2.getTransparency());
                    object.setTransparencyMode(2);
                    lwoSurface.setTransparencyAttributes((TransparencyAttributes)object);
                }
                if (lwoTexture != null) {
                    this.debugOutputLn(8, "texture != null, enable texturing");
                    object = lwoTexture.getTexture();
                    object.setEnable(true);
                    lwoSurface.setTexture((Texture)object);
                    geometryInfo = new TextureAttributes();
                    if (lwoTexture.getType().equals("DTEX")) {
                        geometryInfo.setTextureMode(2);
                    } else if (lwoTexture.getType().equals("CTEX")) {
                        geometryInfo.setTextureMode(3);
                    }
                    lwoSurface.setTextureAttributes((TextureAttributes)geometryInfo);
                } else {
                    this.debugOutputLn(8, "texture == null, no texture to use");
                }
            }
            this.debugOutputLn(8, "done creating object");
            shapeHolder.nullify();
            this.objectShape = new Shape3D((Geometry)pointArray);
            this.objectShape.setAppearance((Appearance)lwoSurface);
            this.objectShapeList.addElement(this.objectShape);
        }
    }

    void calculateTextureCoords(LwoTexture lwoTexture, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2) {
        this.debugOutputLn(1, "calculateTextureCoords()");
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = lwoTexture.getTextureAxis();
        Vector3f vector3f = lwoTexture.getTextureSize();
        Vector3f vector3f2 = lwoTexture.getTextureCenter();
        String string = lwoTexture.getMappingType();
        if (string.startsWith("Cylindrical")) {
            this.calculateCylindricalTextureCoords(n, vector3f, vector3f2, fArray2, nArray2, fArray, nArray);
        } else if (string.startsWith("Spherical")) {
            this.calculateSphericalTextureCoords(n, vector3f2, fArray2, nArray2, fArray, nArray);
        } else if (string.startsWith("Planar")) {
            this.calculatePlanarTextureCoords(n, vector3f, vector3f2, fArray2, nArray2, fArray, nArray);
        }
    }

    double xyztoh(float f, float f2, float f3) {
        if ((double)f == 0.0 && (double)f3 == 0.0) {
            return 0.0;
        }
        if ((double)f3 == 0.0) {
            return (double)f < 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if ((double)f3 < 0.0) {
            return -Math.atan(f / f3) + Math.PI;
        }
        return -Math.atan(f / f3);
    }

    double xyztop(float f, float f2, float f3) {
        double d = (double)f == 0.0 && (double)f3 == 0.0 ? ((double)f2 != 0.0 ? ((double)f2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : 0.0) : ((double)(f = (float)Math.sqrt(f * f + f3 * f3)) == 0.0 ? ((double)f2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.atan(f2 / f));
        return d;
    }

    void calculateSphericalTextureCoords(int n, Vector3f vector3f, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2) {
        this.debugOutputLn(1, "calculateSphericalTextureCoords");
        int n2 = 0;
        while (n2 < nArray2.length) {
            double d;
            double d2;
            float f = fArray2[3 * nArray2[n2]] - vector3f.x;
            float f2 = fArray2[3 * nArray2[n2] + 1] - vector3f.y;
            float f3 = -(fArray2[3 * nArray2[n2] + 2] + vector3f.z);
            if (n == 1) {
                d2 = this.xyztoh(f3, f, -f2);
                d = this.xyztop(f3, f, -f2);
            } else if (n == 2) {
                d2 = this.xyztoh(-f, f2, f3);
                d = this.xyztop(-f, f2, f3);
            } else {
                d2 = this.xyztoh(-f, f3, -f2);
                d = this.xyztop(-f, f3, -f2);
            }
            d2 = 1.0 - d2 / (Math.PI * 2);
            d = -(0.5 - d / Math.PI);
            fArray[nArray2[n2] * 2] = (float)d2;
            fArray[nArray2[n2] * 2 + 1] = (float)d;
            nArray[n2] = nArray2[n2];
            ++n2;
        }
    }

    void calculateCylindricalTextureCoords(int n, Vector3f vector3f, Vector3f vector3f2, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2) {
        this.debugOutputLn(1, "calculateCylindricalTextureCoords");
        this.debugOutputLn(2, "axis, size, center, tc, ti, v, i = " + n + ", " + vector3f + ", " + vector3f2 + ", " + fArray + ", " + nArray + ", " + fArray2 + ", " + nArray2);
        this.debugOutputLn(2, "Cyl Texture Coords:");
        int n2 = 0;
        while (n2 < nArray2.length) {
            double d;
            double d2;
            float f = fArray2[3 * nArray2[n2]] - vector3f2.x;
            float f2 = fArray2[3 * nArray2[n2] + 1] - vector3f2.y;
            float f3 = -(fArray2[3 * nArray2[n2] + 2] + vector3f2.z);
            if (n == 1) {
                d2 = this.xyztoh(f3, f, -f2);
                d = (double)(f / vector3f.x) + 0.5;
            } else if (n == 2) {
                d2 = this.xyztoh(-f, f2, f3);
                d = (double)(f2 / vector3f.y) + 0.5;
            } else {
                d2 = this.xyztoh(-f, f3, -f2);
                d = (double)(f3 / vector3f.z) + 0.5;
            }
            d2 = 1.0 - d2 / (Math.PI * 2);
            fArray[nArray2[n2] * 2] = (float)d2;
            fArray[nArray2[n2] * 2 + 1] = (float)d;
            nArray[n2] = nArray2[n2];
            this.debugOutputLn(2, "x, y, z = " + f + ", " + f2 + ", " + f3 + "    " + "s, t = " + d2 + ", " + d);
            ++n2;
        }
    }

    void calculatePlanarTextureCoords(int n, Vector3f vector3f, Vector3f vector3f2, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2) {
        this.debugOutputLn(1, "calculatePlanarTextureCoords");
        this.debugOutputLn(2, "size, center, axis = " + vector3f + vector3f2 + ", " + n);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (n == 1) {
            f2 = -1.0f / vector3f.z;
            f3 = 1.0f / vector3f.y;
        } else if (n == 2) {
            f = 1.0f / vector3f.x;
            f4 = -1.0f / vector3f.z;
        } else {
            f = 1.0f / vector3f.x;
            f3 = 1.0f / vector3f.y;
        }
        this.debugOutputLn(2, "Planar Texture Coords:");
        int n2 = 0;
        while (n2 < nArray2.length) {
            float f5 = fArray2[3 * nArray2[n2]] - vector3f2.x;
            float f6 = fArray2[3 * nArray2[n2] + 1] - vector3f2.y;
            float f7 = fArray2[3 * nArray2[n2] + 2] + vector3f2.z;
            double d = (double)(f5 * f + f7 * f2) + 0.5;
            double d2 = (double)(f6 * f3 + f7 * f4) + 0.5;
            fArray[nArray2[n2] * 2] = (float)d;
            fArray[nArray2[n2] * 2 + 1] = (float)d2;
            nArray[n2] = nArray2[n2];
            this.debugOutputLn(2, "x, y, z = " + f5 + ", " + f6 + ", " + f7 + "    " + "s, t = " + d + ", " + d2);
            ++n2;
        }
    }

    Shape3D getJava3dShape() {
        return this.objectShape;
    }

    Vector getJava3dShapeList() {
        return this.objectShapeList;
    }
}

