/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.updatechecker;

import com.isti.util.IstiXmlUtils;
import com.isti.util.updatechecker.BasicUpdateCheckerServer;
import com.isti.util.updatechecker.LocationUpdate;
import com.isti.util.updatechecker.UpdateAction;
import com.isti.util.updatechecker.UpdateInformation;
import java.util.List;
import java.util.Properties;
import org.jdom.Element;

public class XMLUpdateCheckerServer
extends BasicUpdateCheckerServer {
    public static final String UPDATE_CHECKER_TAG = "UpdateChecker";
    public static final String ADMIN_EMAIL = "AdminEmail";
    public static final String UPDATE = "Update";
    public static final String VERSION = "Version";
    public static final String DATE = "Date";
    public static final String FEATURES = "Features";
    public static final String REASON = "Reason";
    public static final String UPDATE_ACTION = "UpdateAction";
    public static final String DESCRIPTION = "Description";
    public static final String UPDATE_LOCATION = "UpdateLocation";
    protected static final IstiXmlUtils istiXmlUtilsObj = new IstiXmlUtils();

    public XMLUpdateCheckerServer(String updateLocationString) {
        this(updateLocationString, (Properties)null);
    }

    public XMLUpdateCheckerServer(String updateLocationString, Properties urlRequestProps) {
        this(XMLUpdateCheckerServer.createRootElement(updateLocationString, urlRequestProps));
    }

    public XMLUpdateCheckerServer(Element rootElement) {
        super(XMLUpdateCheckerServer.createAdminEmailAddress(rootElement), XMLUpdateCheckerServer.createUpdates(rootElement));
    }

    public boolean getErrorFlag() {
        return istiXmlUtilsObj.getErrorFlag();
    }

    public String getErrorMessage() {
        return istiXmlUtilsObj.getErrorMessage();
    }

    protected static Element createRootElement(String updateLocationString) {
        return XMLUpdateCheckerServer.createRootElement(updateLocationString, null);
    }

    protected static Element createRootElement(String updateLocationString, Properties urlRequestProps) {
        Element rootElement = null;
        if (!istiXmlUtilsObj.loadFile(updateLocationString, UPDATE_CHECKER_TAG, urlRequestProps)) {
            return rootElement;
        }
        rootElement = istiXmlUtilsObj.getRootElement();
        return rootElement;
    }

    protected static String getChildText(Element e, String name) {
        String text = null;
        Element child = e.getChild(name);
        if (child != null) {
            text = child.getText();
        }
        return text;
    }

    protected static String createAdminEmailAddress(Element rootElement) {
        if (rootElement == null) {
            return null;
        }
        return XMLUpdateCheckerServer.getChildText(rootElement, ADMIN_EMAIL);
    }

    protected static UpdateInformation[] createUpdates(Element rootElement) {
        if (rootElement == null) {
            return new UpdateInformation[0];
        }
        List children = rootElement.getChildren(UPDATE);
        UpdateInformation[] updates = new UpdateInformation[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            Element currentElement = (Element)children.get(i);
            String versionString = currentElement.getAttributeValue(VERSION);
            String versionDate = currentElement.getAttributeValue(DATE);
            String features = XMLUpdateCheckerServer.getChildText(currentElement, FEATURES);
            String reasons = XMLUpdateCheckerServer.getChildText(currentElement, REASON);
            UpdateAction[] updateActions = XMLUpdateCheckerServer.createUpdateActions(currentElement);
            updates[i] = new UpdateInformation(versionString, versionDate, features, reasons, updateActions);
        }
        return updates;
    }

    protected static UpdateAction[] createUpdateActions(Element updateElement) {
        List children = updateElement.getChildren(UPDATE_ACTION);
        UpdateAction[] actions = new UpdateAction[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            Element currentElement = (Element)children.get(i);
            String description = currentElement.getAttributeValue(DESCRIPTION);
            String location = XMLUpdateCheckerServer.getChildText(currentElement, UPDATE_LOCATION);
            actions[i] = new LocationUpdate(description, location);
        }
        return actions;
    }
}

