/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.CfgPropItem;
import com.isti.util.LogFile;
import com.isti.util.UtilFns;
import com.isti.util.gui.HandJButton;
import com.isti.util.gui.IstiPasswordDialog;
import com.isti.util.propertyeditor.LoginInformation;
import com.isti.util.propertyeditor.ShowDialogPropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.JButton;

public class LoginPropertyEditor
extends ShowDialogPropertyEditor {
    private static final String SIZING_STRING = "LoginPropertyEditorSize";
    public static final String DEF_TITLE_STR = "Login Information";
    private static final String DEF_BUTTON_STR = "Login Information";
    private final JButton editorButtonObj = new HandJButton("Login Information");
    private LoginInformation editorLoginInformationObj = null;
    protected final Vector listenerList = new Vector();
    private IstiPasswordDialog currentPwdDialogObj = null;
    private Component parentComponentObj = null;
    private boolean dialogModalFlag = false;
    private String loginDialogMsgStr = null;
    static /* synthetic */ Class class$java$lang$String;

    public LoginPropertyEditor() {
        this(null);
    }

    public LoginPropertyEditor(Component parentCompObj) {
        this.parentComponentObj = parentCompObj;
        this.editorButtonObj.setMargin(new Insets(0, 0, 0, 0));
        FontMetrics metObj = this.editorButtonObj.getFontMetrics(this.editorButtonObj.getFont());
        this.editorButtonObj.setPreferredSize(new Dimension(metObj.stringWidth(SIZING_STRING) + 15, metObj.getHeight() + 4));
        this.editorButtonObj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPropertyEditor.this.showEditorDialog(LoginPropertyEditor.this.editorButtonObj, null);
            }
        });
    }

    public void setDialogModalFlag(boolean flgVal) {
        this.dialogModalFlag = flgVal;
    }

    public boolean getDialogModalFlag() {
        return this.dialogModalFlag;
    }

    public boolean showEditorDialog() {
        return this.showEditorDialog(null, null);
    }

    public boolean showEditorDialog(String panelPromptStr) {
        return this.showEditorDialog(null, panelPromptStr);
    }

    public boolean showEditorDialog(Component parentComp, String panelPromptStr) {
        boolean retFlag = false;
        if (this.currentPwdDialogObj == null) {
            if (this.loginDialogMsgStr != null) {
                panelPromptStr = panelPromptStr != null ? panelPromptStr + this.loginDialogMsgStr : this.loginDialogMsgStr;
            }
            this.currentPwdDialogObj = this.createDialog(parentComp != null ? parentComp : this.parentComponentObj, panelPromptStr);
            LoginPropertyEditor.setupDialog(this.getLoginInformation(), this.currentPwdDialogObj);
            if (this.currentPwdDialogObj.showAndWait() == IstiPasswordDialog.LOGIN_DIALOG_DEFAULT_OPTION_STRING) {
                this.setLoginInformation(this.currentPwdDialogObj.getUsernameText(), this.currentPwdDialogObj.getPasswordText());
                retFlag = true;
            }
            this.currentPwdDialogObj = null;
        } else {
            this.currentPwdDialogObj.requestFocus();
        }
        return retFlag;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(l);
    }

    public IstiPasswordDialog createDialog(Component parent, String panelPromptStr) {
        IstiPasswordDialog dialogObj = new IstiPasswordDialog(parent, "Login Information", panelPromptStr);
        dialogObj.setModal(this.dialogModalFlag);
        return dialogObj;
    }

    public IstiPasswordDialog createDialog(Component parent) {
        return this.createDialog(parent, null);
    }

    public static LoginInformation createLoginInformation(LoginInformation loginInformationObj, String text) {
        if (loginInformationObj != null) {
            try {
                Class<?> valueClass = loginInformationObj.getClass();
                Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LoginPropertyEditor.class$("java.lang.String")) : class$java$lang$String};
                Constructor<?> c = valueClass.getConstructor(parameterTypes);
                Object[] initargs = new Object[]{text};
                LoginInformation newLoginInfoObj = (LoginInformation)c.newInstance(initargs);
                newLoginInfoObj.copyLoginInfoResources(loginInformationObj);
                return newLoginInfoObj;
            }
            catch (Exception ex) {
                LogFile.getGlobalLogObj(true).warning("Error creating login information object:  " + ex);
                LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
                return null;
            }
        }
        return new LoginInformation(text);
    }

    public static LoginInformation createLoginInformation(LoginInformation loginInformationObj, String usernameText, String passwordText) {
        if (loginInformationObj != null) {
            try {
                Class<?> valueClass = loginInformationObj.getClass();
                Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LoginPropertyEditor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = LoginPropertyEditor.class$("java.lang.String")) : class$java$lang$String};
                Constructor<?> c = valueClass.getConstructor(parameterTypes);
                Object[] initargs = new Object[]{usernameText, passwordText};
                LoginInformation newLoginInfoObj = (LoginInformation)c.newInstance(initargs);
                newLoginInfoObj.copyLoginInfoResources(loginInformationObj);
                return newLoginInfoObj;
            }
            catch (Exception ex) {
                LogFile.getGlobalLogObj(true).warning("Error creating login information object:  " + ex);
                LogFile.getGlobalLogObj(true).warning(UtilFns.getStackTraceString(ex));
                return null;
            }
        }
        return new LoginInformation(usernameText, passwordText);
    }

    public String getAsText() {
        return this.getLoginInformation().toString();
    }

    public Component getCustomEditor() {
        return this.editorButtonObj;
    }

    public LoginInformation getLoginInformation() {
        if (this.editorLoginInformationObj == null) {
            this.editorLoginInformationObj = new LoginInformation();
        }
        return this.editorLoginInformationObj;
    }

    public String getPasswordText() {
        return this.getLoginInformation().getPasswordText();
    }

    public String getUsernameText() {
        return this.getLoginInformation().getUsernameText();
    }

    public Object getValue() {
        return this.getLoginInformation();
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(l);
    }

    public void setAsText(String text) {
        this.setValue(LoginPropertyEditor.createLoginInformation(this.editorLoginInformationObj, text));
    }

    public static void setupDialog(LoginInformation loginInformationObj, IstiPasswordDialog dialogObj) {
        dialogObj.setUsernameAsInitalFocus();
        dialogObj.setUsernameText(loginInformationObj.getUsernameText());
        dialogObj.setPasswordText(loginInformationObj.isEncrypted() ? "" : loginInformationObj.getPasswordText());
    }

    public void setValue(LoginInformation loginInformationObj) {
        if (loginInformationObj == null || loginInformationObj.equals(this.editorLoginInformationObj)) {
            return;
        }
        this.editorLoginInformationObj = loginInformationObj;
        String usernameText = loginInformationObj.getUsernameText();
        if (usernameText.length() > 0) {
            this.editorButtonObj.setText(usernameText);
        } else {
            this.editorButtonObj.setText("Login Information");
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, "value set"));
    }

    public void setValue(Object someObj) {
        if (someObj == null) {
            return;
        }
        if (someObj instanceof LoginInformation) {
            this.setValue((LoginInformation)someObj);
        } else if (someObj instanceof CfgPropItem) {
            this.setValue(((CfgPropItem)someObj).getValue());
        } else {
            this.setAsText(someObj.toString());
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.toArray();
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((ActionListener)listeners[i]).actionPerformed(event);
        }
    }

    protected void setLoginInformation(String usernameText, String passwordText) {
        this.setValue(LoginPropertyEditor.createLoginInformation(this.editorLoginInformationObj, usernameText, passwordText));
    }

    public void setLoginDialogMsgStr(String str) {
        this.loginDialogMsgStr = str;
    }

    public String getLoginDialogMsgStr() {
        return this.loginDialogMsgStr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

