/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.gui.textvalidator.SQLTextUtils;
import com.isti.util.gui.textvalidator.TextBasicValidator;
import java.sql.Date;
import java.util.GregorianCalendar;

public class TextSQLDateValidator
extends TextBasicValidator {
    public static final String DATE_DESCRIPTION_TEXT = "year-month-day";
    public static final String DATE_FORMAT_TEXT = "yyyy-mm-dd";
    public static final String SEPARATOR_CHARS = "-";
    public static final String ALLOWED_CHARS = "0123456789-";
    private static final String TOOLTIP_TEXT = "year-month-day (yyyy-mm-dd)";
    private final int minYear;
    private final int maxYear;

    public TextSQLDateValidator() {
        this(-1, -1);
    }

    public TextSQLDateValidator(int minYear, int maxYear) {
        super(ALLOWED_CHARS, DATE_FORMAT_TEXT.length(), TOOLTIP_TEXT, false, DATE_FORMAT_TEXT.length(), true);
        this.minYear = minYear;
        this.maxYear = maxYear;
    }

    public boolean isValid(String s) {
        return TextSQLDateValidator.isValidDate(s);
    }

    public static boolean isValidDate(String s) {
        int integerCharCount = 0;
        int integerFieldCount = 0;
        int separatorCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ("0123456789".indexOf(c) >= 0) {
                int maxIntegerCharCount;
                if (!(++integerCharCount == 1 ? ++integerFieldCount > 3 : integerCharCount > (maxIntegerCharCount = integerFieldCount == 1 ? 4 : 2))) continue;
                return false;
            }
            if (SEPARATOR_CHARS.indexOf(c) >= 0) {
                if (i != 0 && integerCharCount == 0) {
                    return false;
                }
                if (++separatorCount > 2) {
                    return false;
                }
                integerCharCount = 0;
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isValidEntry(String s) {
        try {
            Date d = SQLTextUtils.getDateValue(s);
            if (d != null) {
                if (this.minYear >= 0 || this.maxYear >= 0) {
                    GregorianCalendar g = new GregorianCalendar();
                    g.setTime(d);
                    int year = g.get(1);
                    if (this.minYear >= 0 && year < this.minYear) {
                        return false;
                    }
                    if (this.maxYear >= 0 && year > this.maxYear) {
                        return false;
                    }
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

