/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.IstiNamedValueInterface;
import com.isti.util.PropItemInterface;
import com.isti.util.gis.GisUtils;
import com.isti.util.gis.IstiRegion;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.IstiDialogUtil;
import com.isti.util.gui.IstiRegionPanel;
import com.isti.util.gui.SplashWindow;
import com.isti.util.propertyeditor.IstiNamedValueComponentPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class IstiRegionEditPanel
extends JPanel {
    public static final String showDialogCommandString = "show dialog";
    public static final String closeDialogCommandString = "close dialog";
    public static final String OK_OPTION_TEXT = "OK";
    public static final String HELP_OPTION_TEXT = "Help";
    private static Vector listenerList = new Vector();
    private static final String TEXT_AREA_COORD_SEP_CHAR = "\n";
    private IstiDialogPopup dialogObj = null;
    protected final IstiDialogUtil dialogUtilObj = new IstiDialogUtil(this);
    private final IstiNamedValueComponentPanel optionsComponentPanel = new IstiNamedValueComponentPanel();
    private static final int NUM_ROWS = 4;
    private static final int NUM_COLUMNS = 40;
    private final JTextArea textArea = new JTextArea("", 4, 40);
    private static Object activeIstiRegionEditPanelSyncObj = new Object();
    private static IstiRegionEditPanel activeIstiRegionEditPanel = null;
    private boolean circleFlag = false;
    private IstiRegionPanel regionPanel = null;
    private boolean addFlag = true;
    private IstiRegion.LatLonPoint circleLatLonPoint = null;
    private final List optionGroups;

    public IstiRegionEditPanel() {
        this((List)null);
    }

    public IstiRegionEditPanel(List optionGroups) {
        this(optionGroups, "");
    }

    public IstiRegionEditPanel(List optionGroups, String str) {
        this.optionGroups = optionGroups;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setRegionString(str);
    }

    protected final void jbInit() throws Exception {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraintsObj = new GridBagConstraints();
        constraintsObj.anchor = 10;
        constraintsObj.fill = 2;
        constraintsObj.insets = new Insets(2, 0, 2, 0);
        constraintsObj.weightx = 1.0;
        constraintsObj.weighty = 0.25;
        constraintsObj.gridy = 0;
        constraintsObj.gridx = 0;
        constraintsObj.gridheight = 1;
        constraintsObj.gridwidth = 1;
        ++constraintsObj.gridy;
        ++constraintsObj.gridy;
        constraintsObj.weighty = 0.75;
        buttonsPanel.add(Box.createVerticalStrut(1), constraintsObj);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
        JScrollPane listScrollPane = new JScrollPane(this.textArea, 20, 30);
        JPanel scrollPanePanel = new JPanel(new BorderLayout());
        scrollPanePanel.add((Component)listScrollPane, "Center");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        constraintsObj.gridy = 0;
        constraintsObj.gridx = 0;
        constraintsObj.gridheight = 1;
        constraintsObj.gridwidth = 2;
        IstiNamedValueInterface[] defaultOptions = IstiRegion.getDefaultOptions();
        for (int i = 0; i < defaultOptions.length; ++i) {
            PropItemInterface defaultItem;
            Object groupSelObj;
            IstiNamedValueInterface defaultOption = defaultOptions[i];
            if (this.optionGroups != null && defaultOption instanceof PropItemInterface && (groupSelObj = (defaultItem = (PropItemInterface)defaultOption).getGroupSelObj()) != null && this.optionGroups.indexOf(groupSelObj) < 0) continue;
            this.optionsComponentPanel.addProperty(defaultOption);
        }
        ++constraintsObj.gridy;
        constraintsObj.gridx = 0;
        mainPanel.add((Component)this.optionsComponentPanel, constraintsObj);
        constraintsObj.gridwidth = 1;
        ++constraintsObj.gridy;
        constraintsObj.gridx = 0;
        mainPanel.add((Component)new JLabel("Region data: "), constraintsObj);
        ++constraintsObj.gridx;
        mainPanel.add((Component)scrollPanePanel, constraintsObj);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        this.add((Component)buttonsPanel, "East");
    }

    public static void addActivePanelActionListener(ActionListener l) {
        listenerList.add(l);
    }

    public void addPoint(double lat, double lon) {
        String text = this.textArea.getText();
        if (this.isCircle()) {
            if (this.circleLatLonPoint == null) {
                this.circleLatLonPoint = new IstiRegion.LatLonPoint(lat, lon);
                this.textArea.setText(IstiRegion.coordToString(lat, lon));
            } else {
                double radius = GisUtils.sphereDist(this.circleLatLonPoint.getLat(), this.circleLatLonPoint.getLon(), lat, lon);
                this.textArea.append(IstiRegion.radiusToString(radius));
                this.notifyOpenEvent();
                this.dialogObj.requestFocus();
                this.circleLatLonPoint = null;
            }
        } else {
            if (text.length() > 0 && !text.endsWith(TEXT_AREA_COORD_SEP_CHAR)) {
                this.textArea.append(TEXT_AREA_COORD_SEP_CHAR);
            }
            this.textArea.append(IstiRegion.coordToString(lat, lon));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPointToActivePanel(double lat, double lon) {
        Object object = activeIstiRegionEditPanelSyncObj;
        synchronized (object) {
            if (activeIstiRegionEditPanel != null) {
                activeIstiRegionEditPanel.addPoint(lat, lon);
            }
        }
    }

    public void createDialog(final IstiRegionPanel regionPanel, boolean addFlag, Component parentComp, boolean modalFlag, boolean centerFlag) {
        Object[] objectArray;
        int msgType = -1;
        int optionType = -1;
        if (regionPanel.isHelpActionListenerInstalled()) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = OK_OPTION_TEXT;
            objectArray2[1] = "Cancel";
            objectArray = objectArray2;
            objectArray2[2] = HELP_OPTION_TEXT;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = OK_OPTION_TEXT;
            objectArray = objectArray3;
            objectArray3[1] = "Cancel";
        }
        Object[] optionsArr = objectArray;
        this.regionPanel = regionPanel;
        this.addFlag = addFlag;
        this.dialogObj = new IstiDialogPopup(parentComp, this, "", -1, optionsArr, 0, modalFlag, false, -1);
        final JOptionPane paneObj = this.dialogObj.getOptionPaneObj();
        if (!centerFlag) {
            try {
                Dimension screenSizeDimObj = SplashWindow.getDisplayScreenSize();
                this.dialogObj.setLocation(screenSizeDimObj.width - this.dialogObj.getDialogObj().getWidth(), 2);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.dialogObj.setHideDialogOnButtonFlag(false);
        this.dialogObj.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                String prop = evt.getPropertyName();
                if (IstiRegionEditPanel.this.dialogObj.isVisible() && evt.getSource() == paneObj && ("value".equals(prop) || "inputValue".equals(prop))) {
                    String str;
                    IstiRegion region;
                    Object value = paneObj.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if (IstiRegionEditPanel.HELP_OPTION_TEXT.equals(newValue)) {
                        if (regionPanel != null) {
                            regionPanel.notifyHelpActionListener(IstiRegionEditPanel.this);
                        }
                        paneObj.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        return;
                    }
                    if (IstiRegionEditPanel.OK_OPTION_TEXT.equals(newValue) && ((region = IstiRegion.parse(str = IstiRegionEditPanel.this.getRegionString())) == null || !(!IstiRegionEditPanel.this.isCircle() ? region instanceof IstiRegion.Polygon : region instanceof IstiRegion.Circle))) {
                        IstiRegionEditPanel.this.dialogUtilObj.popupErrorMessage("Invalid region data");
                        paneObj.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        return;
                    }
                    IstiRegionEditPanel.this.dialogObj.setVisible(false);
                }
            }
        });
    }

    public IstiDialogPopup getDialog() {
        return this.dialogObj;
    }

    public void closeDialog() {
        if (this.dialogObj != null) {
            this.dialogObj.close();
        }
    }

    public void requestFocus() {
        if (this.dialogObj != null) {
            this.dialogObj.requestFocus();
        }
        super.requestFocus();
    }

    public String getRegionString() {
        String dataText = this.textArea.getText().trim();
        String str = "";
        IstiNamedValueInterface[] options = this.optionsComponentPanel.getProperties();
        for (int i = 0; i < options.length; ++i) {
            IstiNamedValueInterface option = options[i];
            if ("name".equals(option.getName())) {
                String regionName = option.stringValue();
                if (regionName.length() > 0) {
                    str = str + "\"" + regionName + "\"" + " ";
                }
                if (dataText.length() <= 0) continue;
                dataText = IstiRegionEditPanel.replace(dataText, TEXT_AREA_COORD_SEP_CHAR.charAt(0), ",".charAt(0));
                str = str + dataText;
                continue;
            }
            if (option.isDefaultValue()) continue;
            str = str + " [" + option.toString() + "]";
        }
        str = str.replace(TEXT_AREA_COORD_SEP_CHAR.charAt(0), ' ');
        return str;
    }

    public boolean isCircle() {
        return this.circleFlag;
    }

    public static void removeActivePanelActionListener(ActionListener l) {
        listenerList.remove(l);
    }

    public static void removeAllActivePanelActionListeners() {
        listenerList.clear();
    }

    public void setCircle(boolean b) {
        this.circleFlag = b;
    }

    public final void setRegionString(String str) {
        IstiRegion regionObj = IstiRegion.parse(str, true);
        if (regionObj != null) {
            IstiNamedValueInterface[] defaultOptions = this.optionsComponentPanel.getDefaultProperties();
            for (int optionIndex = 0; optionIndex < defaultOptions.length; ++optionIndex) {
                IstiNamedValueInterface defaultOption = defaultOptions[optionIndex];
                PropertyEditor propertyEditor = this.optionsComponentPanel.getPropertyEditor(defaultOption);
                if (propertyEditor != null) {
                    String optionText = regionObj.getOptionStringValue(defaultOption.getName());
                    if (optionText == null) continue;
                    propertyEditor.setAsText(optionText);
                    continue;
                }
                System.out.println("No editor for: " + defaultOption.getName());
            }
        }
        if (str.length() > 0) {
            int optionEndIndex;
            int optionBeginIndex;
            int nameEndIndex;
            int nameBeginIndex;
            do {
                nameBeginIndex = str.indexOf("\"");
                nameEndIndex = str.lastIndexOf("\"");
                if (nameBeginIndex < 0 || nameBeginIndex >= nameEndIndex) continue;
                if (regionObj == null && nameBeginIndex < nameEndIndex - 2) {
                    String nameStr = str.substring(nameBeginIndex + 1, nameEndIndex);
                }
                str = str.substring(0, nameBeginIndex) + str.substring(nameEndIndex + 1);
            } while (nameBeginIndex >= 0 || nameEndIndex >= 0);
            do {
                optionBeginIndex = str.indexOf("[");
                optionEndIndex = str.indexOf("]");
                if (optionBeginIndex < 0 || optionBeginIndex >= optionEndIndex) continue;
                str = str.substring(0, optionBeginIndex) + str.substring(optionEndIndex + 1);
            } while (optionBeginIndex >= 0 || optionEndIndex >= 0);
            str = IstiRegionEditPanel.replace(str, ",".charAt(0), TEXT_AREA_COORD_SEP_CHAR.charAt(0));
            if (regionObj != null) {
                this.setCircle(regionObj instanceof IstiRegion.Circle);
            }
        }
        this.textArea.setText(str.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showDialog() {
        if (this.dialogObj == null) {
            return -1;
        }
        String titleStr = this.addFlag ? "Add" : "Edit";
        titleStr = this.circleFlag ? titleStr + " Circle" : titleStr + " Polygon";
        titleStr = titleStr + " Region";
        this.dialogObj.setTitleStr(titleStr);
        Object object = activeIstiRegionEditPanelSyncObj;
        synchronized (object) {
            if (activeIstiRegionEditPanel != null) {
                activeIstiRegionEditPanel.getDialog().close();
                activeIstiRegionEditPanel = null;
            }
            activeIstiRegionEditPanel = this;
        }
        this.notifyOpenEvent();
        this.dialogObj.pack();
        int retVal = this.dialogObj.showAndReturnIndex();
        Object object2 = activeIstiRegionEditPanelSyncObj;
        synchronized (object2) {
            activeIstiRegionEditPanel = null;
        }
        this.notifyCloseEvent();
        return retVal;
    }

    protected void clearRegion() {
        if (this.dialogUtilObj.popupYesNoConfirmMessage("Are you sure you want to clear the region?", "Confirm Clear", true) != 0) {
            return;
        }
        this.setRegionString("");
    }

    protected static void fireActivePanelActionPerformed(ActionEvent event) {
        Object[] listeners = listenerList.toArray();
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((ActionListener)listeners[i]).actionPerformed(event);
        }
    }

    protected void notifyCloseEvent() {
        IstiRegionEditPanel.fireActivePanelActionPerformed(new ActionEvent(this, 1001, closeDialogCommandString));
        if (this.regionPanel != null) {
            this.regionPanel.dialogObj.requestFocus();
        }
    }

    protected void notifyOpenEvent() {
        IstiRegionEditPanel.fireActivePanelActionPerformed(new ActionEvent(this, 1001, showDialogCommandString));
    }

    protected static String replace(String str, char oldChar, char newChar) {
        String endStr;
        String startStr;
        int coordStart = str.indexOf("(");
        int coordEnd = str.lastIndexOf(")");
        if (coordStart >= 0 && coordEnd >= 0) {
            startStr = str.substring(0, coordStart);
            endStr = str.substring(coordEnd + 1);
            str = str.substring(coordStart, coordEnd + 1);
        } else {
            startStr = "";
            endStr = "";
        }
        str = str.replace(oldChar, newChar);
        return startStr + str + endStr;
    }
}

