/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.gui.ChooserPreviewPanel;
import com.isti.util.gui.NameColorChooserPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class IstiColorChooser
extends JColorChooser {
    protected final ChooserPreviewPanel previewPanel;

    public IstiColorChooser(Color initialColor) {
        super(initialColor);
        this.previewPanel = new ChooserPreviewPanel(this, initialColor);
        this.addChooserPanel(new NameColorChooserPanel());
        Dimension sizeObj = this.previewPanel.getPreferredSize();
        this.previewPanel.setSize(sizeObj);
        this.previewPanel.setMinimumSize(sizeObj);
        this.previewPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.setPreviewPanel(this.previewPanel);
        this.getSelectionModel().addChangeListener(this.previewPanel);
    }

    public void setColor(Color color) {
        super.setColor(color);
        this.previewPanel.setColor(color);
    }

    public static Color showDialog(Component component, String title, Color initialColor) {
        IstiColorChooser pane = new IstiColorChooser(initialColor);
        JDialog dialogObj = JColorChooser.createDialog(component, title, true, pane, pane.previewPanel, null);
        pane.setColor(initialColor);
        dialogObj.setVisible(true);
        Window windowObj = IstiColorChooser.getWindowForComponent(component);
        if (windowObj != null) {
            windowObj.requestFocus();
        }
        return pane.previewPanel.getColor();
    }

    private static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return IstiColorChooser.getWindowForComponent(parentComponent.getParent());
    }
}

