/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gis;

public class GisUtils {
    public static final double FEET_TO_METER = 0.3048;
    public static final double METER_TO_FEET = 3.280839895013123;
    public static final double MILE_TO_METER = 1609.344;
    public static final double METER_TO_MILE = 6.213711922373339E-4;
    public static final double MILE_TO_KM = 1.609344;
    public static final double KM_TO_MILE = 0.621371192237334;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double GEO_RADIUS = 6371008.7714;
    public static final double EARTH_EQUATORIAL_RADIUS_METERS = 6378137.0;
    public static final double EARTH_EQUATORIAL_RADIUS_KM = 6378.137;

    private GisUtils() {
    }

    public static double sphereDist(double rlat1, double rlon1, double rlat2, double rlon2, double dRadius) {
        double sinLatDif = Math.sin((rlat2 - rlat1) * 0.5);
        double sinLonDif = Math.sin((rlon2 - rlon1) * 0.5);
        double sinsquareCby2 = sinLatDif * sinLatDif + Math.cos(rlat1) * Math.cos(rlat2) * sinLonDif * sinLonDif;
        return dRadius * 2.0 * Math.asin(Math.sqrt(sinsquareCby2));
    }

    public static double sphereDist(double dlat1, double dlon1, double dlat2, double dlon2) {
        return GisUtils.sphereDist(dlat1 * (Math.PI / 180), dlon1 * (Math.PI / 180), dlat2 * (Math.PI / 180), dlon2 * (Math.PI / 180), 6371008.7714);
    }

    public static double sphereAzim(double rlat1, double rlon1, double rlat2, double rlon2) {
        double dLonDif = rlon2 - rlon1;
        double cosLatP2 = Math.cos(rlat2);
        double a = cosLatP2 * Math.sin(dLonDif);
        double b = Math.cos(rlat1) * Math.sin(rlat2) - cosLatP2 * Math.sin(rlat1) * Math.cos(dLonDif);
        return GisUtils.ptgAtan2(a, b);
    }

    public static double sphereAzimDeg(double dlat1, double dlon1, double dlat2, double dlon2) {
        return GisUtils.sphereAzim(dlat1 * (Math.PI / 180), dlon1 * (Math.PI / 180), dlat2 * (Math.PI / 180), dlon2 * (Math.PI / 180)) * 57.29577951308232;
    }

    public static double ptgAtan2(double a, double b) {
        if (a == 0.0 && b == 0.0) {
            return 0.0;
        }
        return Math.atan2(a, b);
    }

    public static double sphereDistNew(double rlat0, double rlon0, double rlat1, double rlon1, double dRadius) {
        double cosAngle = Math.cos(rlat0) * Math.cos(rlon0) * Math.cos(rlat1) * Math.cos(rlon1) + Math.cos(rlat0) * Math.sin(rlon0) * Math.cos(rlat1) * Math.sin(rlon1) + Math.sin(rlat0) * Math.sin(rlat1);
        return Math.acos(cosAngle) * dRadius;
    }

    public static double sphereDistNew(double dlat0, double dlon0, double dlat1, double dlon1) {
        return GisUtils.sphereDistNew(dlat0 * (Math.PI / 180), dlon0 * (Math.PI / 180), dlat1 * (Math.PI / 180), dlon1 * (Math.PI / 180), 6371008.7714);
    }

    public static double kmToDegrees(double kmVal) {
        return kmVal / 6378.137 * 57.29577951308232;
    }

    public static double degreesToKm(double degVal) {
        return degVal * (Math.PI / 180) * 6378.137;
    }
}

