/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.ModIterator;
import com.isti.util.UtilFns;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class KeyedTreeTable {
    protected final ArrayList valueBlksListObj = new ArrayList();
    protected final HashMap keyEntriesMapObj = new HashMap();
    protected final boolean rejectDuplicatesFlag;

    public KeyedTreeTable(boolean rejectDuplicatesFlag) {
        this.rejectDuplicatesFlag = rejectDuplicatesFlag;
    }

    public synchronized boolean addEntry(Object keyObj, Object valueObj) {
        ArrayList<TimedValueBlock> listObj;
        TimedValueBlock blkObj = new TimedValueBlock(valueObj);
        Object obj = this.keyEntriesMapObj.get(keyObj);
        if (obj instanceof List) {
            listObj = (ArrayList<TimedValueBlock>)obj;
            if (this.rejectDuplicatesFlag) {
                Iterator iterObj = listObj.iterator();
                while (iterObj.hasNext()) {
                    obj = iterObj.next();
                    if (!(obj instanceof TimedValueBlock) || !valueObj.equals(((TimedValueBlock)obj).valueObj)) continue;
                    return false;
                }
            }
        } else {
            listObj = new ArrayList<TimedValueBlock>();
            this.keyEntriesMapObj.put(keyObj, listObj);
        }
        listObj.add(blkObj);
        blkObj.listObj = listObj;
        this.valueBlksListObj.add(blkObj);
        return true;
    }

    public synchronized Iterator getValues(Object keyObj) {
        List listObj;
        Object obj = this.keyEntriesMapObj.get(keyObj);
        if (obj instanceof List && (listObj = (List)obj).size() > 0) {
            return new ModIterator((List)obj){

                public Object next() {
                    Object obj = super.next();
                    return obj instanceof TimedValueBlock ? ((TimedValueBlock)obj).valueObj : obj;
                }
            };
        }
        return null;
    }

    public synchronized boolean removeEntry(Object keyObj, Object valueObj) {
        List listObj;
        int p;
        Object obj = this.keyEntriesMapObj.get(keyObj);
        if (obj instanceof List && (p = (listObj = (List)obj).indexOf(new TimedValueBlock(valueObj))) >= 0 && (obj = listObj.get(p)) instanceof TimedValueBlock) {
            return this.removeTimedValueBlock((TimedValueBlock)obj);
        }
        return false;
    }

    public synchronized boolean removeEntriesForKey(Object keyObj) {
        boolean retFlag = false;
        Object obj = this.keyEntriesMapObj.get(keyObj);
        if (obj instanceof List) {
            ModIterator iterObj = new ModIterator((List)obj);
            while (iterObj.hasNext()) {
                obj = iterObj.next();
                if (!(obj instanceof TimedValueBlock) || !this.removeTimedValueBlock((TimedValueBlock)obj)) continue;
                retFlag = true;
            }
        }
        return retFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator removeOldEntries(long minTimeMsVal, int maxRemoveCount, boolean returnRemovedFlag) {
        ModIterator iterObj;
        KeyedTreeTable keyedTreeTable = this;
        synchronized (keyedTreeTable) {
            if (this.valueBlksListObj.size() <= 0) {
                return null;
            }
            iterObj = new ModIterator(this.valueBlksListObj);
        }
        ArrayList<Object> removedListObj = null;
        int cnt = 0;
        while (iterObj.hasNext()) {
            Object obj = iterObj.next();
            if (!(obj instanceof TimedValueBlock)) continue;
            TimedValueBlock blkObj = (TimedValueBlock)obj;
            if (blkObj.timestamp >= minTimeMsVal) break;
            this.removeTimedValueBlock(blkObj);
            if (returnRemovedFlag) {
                if (removedListObj == null) {
                    removedListObj = new ArrayList<Object>();
                }
                removedListObj.add(blkObj.valueObj);
            }
            if (maxRemoveCount <= 0 || ++cnt < maxRemoveCount) continue;
        }
        return removedListObj != null ? ((AbstractList)removedListObj).iterator() : null;
    }

    public void removeOldEntries(long minTimeMsVal, int maxRemoveCount) {
        this.removeOldEntries(minTimeMsVal, maxRemoveCount, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValuesDisplayStr() {
        ModIterator iterObj;
        StringBuffer buff = new StringBuffer();
        KeyedTreeTable keyedTreeTable = this;
        synchronized (keyedTreeTable) {
            iterObj = new ModIterator(this.valueBlksListObj);
        }
        if (iterObj.hasNext()) {
            while (true) {
                Object obj;
                if (!((obj = iterObj.next()) instanceof TimedValueBlock)) {
                    continue;
                }
                TimedValueBlock blkObj = (TimedValueBlock)obj;
                buff.append("\"" + blkObj.valueObj + "\", time=" + blkObj.timestamp);
                if (!iterObj.hasNext()) break;
                buff.append(", ");
            }
        }
        return buff.toString();
    }

    public synchronized String getTableDisplayStr(String sepStr) {
        StringBuffer buff = new StringBuffer();
        Iterator keySetIterObj = this.keyEntriesMapObj.keySet().iterator();
        if (keySetIterObj.hasNext()) {
            while (true) {
                Object keyObj = keySetIterObj.next();
                buff.append("key=\"" + keyObj + "\", values:  ");
                Iterator iterObj = this.getValues(keyObj);
                if (iterObj != null) {
                    if (iterObj.hasNext()) {
                        while (true) {
                            buff.append("\"" + iterObj.next() + "\"");
                            if (iterObj.hasNext()) {
                                buff.append(", ");
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    buff.append("???");
                }
                if (!keySetIterObj.hasNext()) break;
                buff.append(sepStr);
            }
        }
        return buff.toString();
    }

    public String getTableDisplayStr() {
        return this.getTableDisplayStr(UtilFns.newline);
    }

    protected synchronized boolean removeTimedValueBlock(TimedValueBlock blkObj) {
        boolean retFlag;
        if (blkObj.listObj != null) {
            retFlag = blkObj.listObj.remove(blkObj);
            if (blkObj.listObj.size() <= 0) {
                this.keyEntriesMapObj.values().remove(blkObj.listObj);
            }
            this.valueBlksListObj.remove(blkObj);
        } else {
            retFlag = false;
        }
        return retFlag;
    }

    protected static class TimedValueBlock {
        public final Object valueObj;
        public final long timestamp;
        public List listObj = null;

        public TimedValueBlock(Object valueObj) {
            this.valueObj = valueObj;
            this.timestamp = System.currentTimeMillis();
        }

        public String toString() {
            return this.valueObj != null ? this.valueObj.toString() : "(null)";
        }

        public boolean equals(Object obj) {
            return this.valueObj != null ? this.valueObj.equals(obj instanceof TimedValueBlock ? ((TimedValueBlock)obj).valueObj : obj) : obj == null;
        }

        public int hashCode() {
            return this.valueObj != null ? this.valueObj.hashCode() : 0;
        }
    }
}

