/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FileDataMonitor;
import com.isti.util.IstiNotifyThread;

public class FileMonPollingThread
extends IstiNotifyThread {
    public static final byte[] ERROR_ARRAY = FileDataMonitor.ERROR_ARRAY;
    protected final FileDataMonitor fileDataMonitorObj;
    protected final int pollingIntervalMs;
    protected final int fileAccessTimeOutMs;
    protected final long maxReadBytesLimit;
    protected final boolean indRecoveryFlag;
    protected final FileDataCallBack fileDataCallBackObj;
    protected boolean forceFileReadFlag = false;

    public FileMonPollingThread(String fNameStr, int pollingIntervalMs, int fileAccessTimeOutMs, long maxReadBytesLimit, boolean indRecoveryFlag, FileDataCallBack fileDataCallBackObj) {
        super("FileMonPollingThread-" + fNameStr);
        if (fNameStr == null || fileDataCallBackObj == null) {
            throw new NullPointerException("Null parameter(s)");
        }
        if (pollingIntervalMs <= 0) {
            throw new IllegalArgumentException("pollingIntervalMs <= 0");
        }
        this.fileDataMonitorObj = new FileDataMonitor(fNameStr);
        this.pollingIntervalMs = pollingIntervalMs;
        this.fileAccessTimeOutMs = fileAccessTimeOutMs;
        this.maxReadBytesLimit = maxReadBytesLimit;
        this.indRecoveryFlag = indRecoveryFlag;
        this.fileDataCallBackObj = fileDataCallBackObj;
    }

    public FileMonPollingThread(String fNameStr, int pollingIntervalMs, int fileAccessTimeOutMs, long maxReadBytesLimit, FileDataCallBack fileDataCallBackObj) {
        this(fNameStr, pollingIntervalMs, fileAccessTimeOutMs, maxReadBytesLimit, false, fileDataCallBackObj);
    }

    public void run() {
        boolean lastAttemptFlag = true;
        while (!(this.isTerminated() || !this.waitForNotify(this.pollingIntervalMs) && this.isTerminated())) {
            try {
                byte[] byteArr;
                if (this.forceFileReadFlag) {
                    this.forceFileReadFlag = false;
                    byteArr = this.checkReadFileData(true);
                } else {
                    byteArr = this.checkReadFileData(false);
                }
                if (byteArr != null) {
                    if (byteArr != ERROR_ARRAY) {
                        this.fileDataCallBackObj.callBackMethod(true, byteArr);
                        lastAttemptFlag = true;
                        continue;
                    }
                    this.fileDataCallBackObj.callBackMethod(false, this.fileDataMonitorObj.getErrorMessageString().getBytes());
                    lastAttemptFlag = false;
                    continue;
                }
                if (!this.indRecoveryFlag || lastAttemptFlag) continue;
                this.fileDataCallBackObj.callBackMethod(true, null);
                lastAttemptFlag = true;
            }
            catch (Exception ex) {
                System.err.println("Error in FileMonPollingThread:  " + ex);
                ex.printStackTrace();
            }
        }
    }

    public void fireForceFileRead() {
        this.forceFileReadFlag = true;
        this.notifyThread();
    }

    public byte[] checkReadFileData(boolean forceFileReadFlag) {
        return this.fileDataMonitorObj.checkReadFileData(this.fileAccessTimeOutMs, this.maxReadBytesLimit, forceFileReadFlag);
    }

    public byte[] checkReadFileData() {
        return this.fileDataMonitorObj.checkReadFileData(this.fileAccessTimeOutMs, this.maxReadBytesLimit, false);
    }

    public FileDataMonitor getFileDataMonitorObj() {
        return this.fileDataMonitorObj;
    }

    public boolean getErrorMessageFlag() {
        return this.fileDataMonitorObj.getErrorMessageFlag();
    }

    public String getErrorMessageString() {
        return this.fileDataMonitorObj.getErrorMessageString();
    }

    public static interface FileDataCallBack {
        public void callBackMethod(boolean var1, byte[] var2);
    }
}

