/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.earthworm.EarthwormExport;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncFileCompare;
import edu.sc.seis.seisFile.syncFile.SyncFileReader;
import edu.sc.seis.seisFile.syncFile.SyncFileWriter;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import edu.sc.seis.seisFile.winston.WinstonSCNL;
import edu.sc.seis.seisFile.winston.WinstonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.DataFormatException;
import org.apache.log4j.BasicConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinstonExport {
    private int chunkSeconds = 86400;
    int minGapMillis = 0;
    boolean doExport = false;
    int exportPort = -1;
    String syncfile;
    boolean heartbeatVerbose = false;
    int heartbeat = 5;
    String heartbeatText = "alive";
    int module = 255;
    int institution = 255;
    QueryParams params;
    Properties winstonConfig = new Properties();
    private static final Logger logger = LoggerFactory.getLogger(WinstonExport.class);

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            WinstonExport wE = new WinstonExport(args);
            wE.doit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void doit() throws IOException, SeisFileException, URISyntaxException, SQLException, DataFormatException {
        WinstonUtil winstonUtil = new WinstonUtil(this.winstonConfig);
        SyncFile remoteSyncFile = SyncFile.load(new File(this.syncfile));
        HashMap<WinstonSCNL, SyncFile> remoteSFMap = this.splitByChannel(remoteSyncFile, winstonUtil.getPrefix());
        logger.info("Remote sync file (" + this.syncfile + ") " + remoteSFMap.keySet().size() + " channels.");
        EarthwormExport exporter = this.setUpExport();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sdf.setTimeZone(QueryParams.UTC);
        SyncFileWriter sentSync = new SyncFileWriter("winston sent to dmc", this.syncfile.replace(".sync", "") + "_sent.sync");
        for (WinstonSCNL scnl : remoteSFMap.keySet()) {
            SyncFile localSF = this.pullLocalSyncFile(scnl, this.params.getBegin(), this.params.getEnd(), winstonUtil);
            SyncFileCompare sfCompare = new SyncFileCompare(localSF, remoteSFMap.get(scnl));
            localSF.saveToFile(scnl.getNSLCWithDots() + "_local.sync");
            SyncFile hereNotThere = sfCompare.getInAnotB();
            hereNotThere.saveToFile(scnl.getNSLCWithDots() + "_InlocalNotRemote.sync");
            logger.info(scnl + " here not there synclines=" + hereNotThere.size());
            for (SyncLine sl : hereNotThere) {
                Date s = new Date(sl.getStartTime().getTime());
                Date end = new Date(sl.getEndTime().getTime());
                if (end.before(this.params.getBegin()) || s.after(this.params.getEnd()) || end.getTime() - s.getTime() < (long)this.minGapMillis) continue;
                if (s.before(this.params.getBegin())) {
                    s = this.params.getBegin();
                }
                if (end.after(this.params.getEnd())) {
                    end = this.params.getEnd();
                }
                while (s.before(end)) {
                    Date e = new Date(s.getTime() + (long)(this.chunkSeconds * 1000));
                    if (e.after(end)) {
                        e = end;
                    }
                    Date lastEnd = e;
                    List<TraceBuf2> tbList = winstonUtil.extractData(scnl, s, e);
                    System.out.println("    Extract " + tbList.size() + " from " + sdf.format(s) + " to " + sdf.format(e));
                    for (TraceBuf2 traceBuf2 : tbList) {
                        Date tbStart = traceBuf2.getStartDate();
                        Date tbEnd = traceBuf2.getEndDate();
                        if (tbStart.before(s) || tbEnd.after(end)) continue;
                        exporter.exportWithRetry(traceBuf2);
                        sentSync.appendLine(new SyncLine(sl, tbStart, traceBuf2.getPredictedNextStartDate()), true);
                        if (!tbEnd.after(lastEnd)) continue;
                        lastEnd = tbEnd;
                    }
                    s = lastEnd;
                }
                sentSync.flush();
            }
        }
        sentSync.close();
    }

    public WinstonExport(String[] args) throws FileNotFoundException, IOException, SeisFileException {
        QueryParams defaults = new QueryParams(new String[]{"-n", "*", "-s", "*", "-l", "*", "-c", "*"});
        this.params = new QueryParams(args, defaults);
        List<String> leftOverArgs = this.params.getUnknownArgs();
        this.winstonConfig.put("winston.driver", "com.mysql.jdbc.Driver");
        this.winstonConfig.put("winston.prefix", "W");
        this.winstonConfig.put("winston.url", "jdbc:mysql://localhost/?user=wwsuser&password=");
        Iterator<String> it = leftOverArgs.iterator();
        while (it.hasNext()) {
            String nextArg = it.next();
            if (nextArg.equals("--heartbeatverbose")) {
                this.heartbeatVerbose = true;
                continue;
            }
            if (it.hasNext()) {
                if (nextArg.equals("-p")) {
                    this.winstonConfig.load(new BufferedReader(new FileReader(it.next())));
                    continue;
                }
                if (nextArg.equals("-u")) {
                    this.winstonConfig.put("winston.url", it.next());
                    continue;
                }
                if (nextArg.equals("--syncfile")) {
                    this.syncfile = it.next();
                    continue;
                }
                if (nextArg.equals("--export")) {
                    this.doExport = true;
                    this.exportPort = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--chunk")) {
                    this.chunkSeconds = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--module")) {
                    this.module = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--inst")) {
                    this.institution = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--heartbeat")) {
                    this.heartbeat = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--heartbeatText")) {
                    this.heartbeatText = it.next();
                    continue;
                }
                if (nextArg.equals("--mingapmillis")) {
                    this.minGapMillis = Integer.parseInt(it.next());
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument: " + nextArg);
            }
            throw new IllegalArgumentException("Unknown argument: " + nextArg);
        }
    }

    HashMap<WinstonSCNL, List<Date>> syncFileMinMax(File remoteSyncFile, String winstonPrefix) throws IOException {
        HashMap<WinstonSCNL, List<Date>> out = new HashMap<WinstonSCNL, List<Date>>();
        SyncFileReader reader = new SyncFileReader(remoteSyncFile);
        while (reader.hasNext()) {
            SyncLine sl = reader.next();
            WinstonSCNL scnl = new WinstonSCNL(sl.getSta(), sl.getChan(), sl.getNet(), sl.getLoc(), winstonPrefix);
            if (!out.containsKey(scnl)) {
                out.put(scnl, Arrays.asList(sl.getStartTime(), sl.getEndTime()));
                continue;
            }
            List<Date> dates = out.get(scnl);
            if (dates.get(0).after(sl.getStartTime())) {
                dates.set(0, sl.getStartTime());
            }
            if (!dates.get(1).before(sl.getEndTime())) continue;
            dates.set(1, sl.getEndTime());
        }
        return out;
    }

    SyncFile pullLocalSyncFile(WinstonSCNL scnl, Date begin, Date end, WinstonUtil winstonUtil) throws SQLException {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(QueryParams.UTC);
        cal.setTime(begin);
        int startYear = cal.get(1);
        int startMonth = cal.get(2) + 1;
        int startDay = cal.get(5);
        cal.setTime(end);
        int endYear = cal.get(1);
        int endMonth = cal.get(2) + 1;
        int endDay = cal.get(5);
        SyncFile sf = winstonUtil.calculateSyncBetweenDates(scnl, startYear, startMonth, startDay, endYear, endMonth, endDay, winstonUtil.getDatabaseURL());
        return sf;
    }

    public HashMap<WinstonSCNL, SyncFile> splitByChannel(SyncFile syncFile, String winstonPrefix) {
        HashMap<WinstonSCNL, SyncFile> out = new HashMap<WinstonSCNL, SyncFile>();
        for (SyncLine sl : syncFile) {
            WinstonSCNL scnl = new WinstonSCNL(sl.getSta(), sl.getChan(), sl.getNet(), sl.getLoc(), winstonPrefix);
            if (!out.containsKey(scnl)) {
                SyncFile sf = new SyncFile(syncFile.getDccName() + " " + scnl);
                out.put(scnl, sf);
            }
            out.get(scnl).addLine(sl);
        }
        return out;
    }

    EarthwormExport setUpExport() throws IOException {
        EarthwormExport exporter = new EarthwormExport(this.exportPort, this.module, this.institution, this.heartbeatText, this.heartbeat);
        if (this.heartbeatVerbose) {
            exporter.getHeartbeater().setVerbose(this.heartbeatVerbose);
        }
        if (this.params.isVerbose()) {
            exporter.setVerbose(true);
            System.out.println("Waiting for client connect, port: " + this.exportPort);
        }
        exporter.waitForClient();
        return exporter;
    }
}

