/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.seedlink;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.seedlink.SeedlinkException;
import edu.sc.seis.seisFile.seedlink.SeedlinkPacket;
import edu.sc.seis.seisFile.seedlink.SeedlinkReader;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.Date;

public class Client {
    public static void printHelp(PrintWriter out) {
        out.println("java " + Client.class.getName() + " [-n net][-s sta][-l loc][-c chan][-h host][-p port][-o outfile][-m maxpackets][--timeout seconds][--verbose][--version][--help]" + " [-iout info outfile][-start start time [-end end time]]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws UnknownHostException, IOException, SeedlinkException, SeedFormatException {
        String EMPTY = "";
        String network = "TA";
        String station = "*";
        String location = "";
        String channel = "BHZ";
        String outFile = null;
        String host = "rtserve.iris.washington.edu";
        String start = "";
        String end = "";
        int port = 18000;
        int maxRecords = 10;
        int timeoutSeconds = 120;
        String infoType = "";
        String ioutFile = "";
        boolean verbose = false;
        FilterOutputStream dos = null;
        PrintWriter out = new PrintWriter(System.out, true);
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].equals("-n")) {
                    network = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-s")) {
                    station = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-l")) {
                    location = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-c")) {
                    channel = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-i")) {
                    infoType = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-h")) {
                    host = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-p")) {
                    port = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-o")) {
                    outFile = args[i + 1];
                    ++i;
                    dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
                    continue;
                }
                if (args[i].equals("-m")) {
                    maxRecords = Integer.parseInt(args[i + 1]);
                    ++i;
                    if (maxRecords >= -1) continue;
                    maxRecords = -1;
                    continue;
                }
                if (args[i].equals("--timeout")) {
                    timeoutSeconds = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("--verbose")) {
                    verbose = true;
                    continue;
                }
                if (args[i].equals("--version")) {
                    out.println(BuildVersion.getDetailedVersion());
                    System.exit(0);
                    continue;
                }
                if (args[i].equals("--help")) {
                    Client.printHelp(out);
                    System.exit(0);
                    continue;
                }
                if (args[i].equals("-start")) {
                    start = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-end")) {
                    end = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-iout")) {
                    ioutFile = args[i + 1];
                    ++i;
                    continue;
                }
                System.out.println("Unknown argument " + args[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                out.println("Argument requires parameter " + args[i]);
                Client.printHelp(out);
                System.exit(1);
                continue;
            }
            catch (Throwable ex) {
                out.println("Bad argument " + args[i]);
                Client.printHelp(out);
                System.exit(1);
            }
        }
        SeedlinkReader reader = new SeedlinkReader(host, port, timeoutSeconds, verbose);
        if (verbose) {
            reader.setVerboseWriter(out);
            String[] lines = reader.sendHello();
            out.println("line 1 :" + lines[0]);
            out.println("line 2 :" + lines[1]);
            out.flush();
        }
        if (infoType.length() != 0 || ioutFile.length() != 0) {
            if (infoType.length() == 0) {
                infoType = "STREAMS";
            }
            String infoString = reader.getInfoString(infoType);
            if (ioutFile == null) {
                out.print(infoString);
            } else {
                try (PrintWriter pw = null;){
                    pw = new PrintWriter(ioutFile);
                    pw.print(infoString);
                }
            }
        }
        if (maxRecords != 0) {
            reader.select(network, station, location, channel);
            reader.startData(start, end);
            try {
                for (int i = 0; (maxRecords == -1 || i < maxRecords) && reader.hasNext(); ++i) {
                    SeedlinkPacket slp = reader.readPacket();
                    DataRecord dr = slp.getMiniSeed();
                    if (dos != null) {
                        dr.write((DataOutputStream)dos);
                    }
                    if (dos != null && !verbose) continue;
                    dr.writeASCII(out, "    ");
                    out.flush();
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        if (dos != null) {
            dos.close();
        }
        reader.close();
        out.println("Finished: " + new Date());
    }
}

