/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.gcf;

import edu.sc.seis.seisFile.gcf.AbstractGCFBlock;
import edu.sc.seis.seisFile.gcf.Convert;
import edu.sc.seis.seisFile.gcf.GCFFormatException;
import edu.sc.seis.seisFile.gcf.GCFHeader;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCFBlock
extends AbstractGCFBlock {
    int[] diffData;
    int firstSample;
    int lastSample;
    boolean isSerial;
    public static final String MOCK_SYSID = "WO1234";
    public static final String MOCK_STREAMID = "4321Z0";
    private static final Logger logger = LoggerFactory.getLogger(GCFBlock.class);

    public GCFBlock(GCFHeader header, int[] diffData, int firstSample, int lastSample, boolean isSerial) {
        super(header);
        this.diffData = diffData;
        this.firstSample = firstSample;
        this.lastSample = lastSample;
        this.isSerial = isSerial;
    }

    @Override
    public int getSize() {
        int size = 24;
        size = this.isSerial && this.header.getCompression() == 1 ? (size += this.diffData.length * 3) : (size += this.diffData.length * 4 / this.header.getCompression());
        return size;
    }

    public int[] getDiffData() {
        return this.diffData;
    }

    public int getFirstSample() {
        return this.firstSample;
    }

    public int getLastSample() {
        return this.lastSample;
    }

    public int[] getUndiffData() throws GCFFormatException {
        int[] out = new int[this.getHeader().getNumPoints()];
        out[0] = this.getFirstSample();
        for (int i = 1; i < out.length; ++i) {
            out[i] = out[i - 1] + this.diffData[i];
        }
        if (out[out.length - 1] != this.getLastSample()) {
            throw new GCFFormatException("bad last data point match: expected " + this.getLastSample() + " but was " + out[out.length - 1]);
        }
        return out;
    }

    @Override
    public void write(DataOutput out) throws NumberFormatException, IOException {
        this.header.write(out);
        boolean diff = false;
        out.writeInt(this.firstSample);
        if (this.header.getCompression() == 1 && this.isSerial) {
            out.write(0);
            out.writeShort(0);
            for (int i = 1; i < this.diffData.length; ++i) {
                out.write((this.diffData[i] & 0xFF0000) >> 16);
                out.writeShort((short)(this.diffData[i] & 0xFFFF));
            }
        } else if (this.header.getCompression() == 1 && !this.isSerial) {
            out.writeInt(0);
            for (int i = 1; i < this.diffData.length; ++i) {
                out.writeInt(this.diffData[i]);
            }
        } else if (this.header.getCompression() == 2) {
            out.writeShort(0);
            for (int i = 1; i < this.diffData.length; ++i) {
                out.writeShort((short)(this.diffData[i] & 0xFFFF));
            }
        } else if (this.header.getCompression() == 4) {
            out.write(0);
            for (int i = 1; i < this.diffData.length; ++i) {
                out.write((byte)this.diffData[i]);
            }
        }
        out.writeInt(this.lastSample);
    }

    public static GCFBlock mockGCF(Date startTime, int[] data, boolean isSerial) {
        int[] daySec = Convert.convertTime(startTime);
        int[] diff = new int[data.length];
        diff[0] = 0;
        for (int i = 1; i < diff.length; ++i) {
            diff[i] = data[i] - data[i - 1];
        }
        int max = 0;
        for (int i = 0; i < diff.length; ++i) {
            max = Math.max(max, Math.abs(diff[i]));
        }
        int compression = 1;
        if (max < 128) {
            compression = 4;
        } else if (max < Short.MAX_VALUE) {
            compression = 2;
        }
        GCFHeader h = new GCFHeader(MOCK_SYSID, MOCK_STREAMID, daySec[0], daySec[1], 100, compression, 0, data.length / compression);
        GCFBlock block = new GCFBlock(h, diff, data[0], data[data.length - 1], isSerial);
        return block;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.diffData);
        result = 31 * result + this.firstSample;
        result = 31 * result + (this.isSerial ? 1231 : 1237);
        result = 31 * result + this.lastSample;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GCFBlock other = (GCFBlock)obj;
        if (!Arrays.equals(this.diffData, other.diffData)) {
            return false;
        }
        if (this.firstSample != other.firstSample) {
            return false;
        }
        if (this.isSerial != other.isSerial) {
            return false;
        }
        return this.lastSample == other.lastSample;
    }
}

