/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Equipment;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Site;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Station
extends BaseNodeType {
    String creationDate;
    String terminationDate;
    FloatType lat;
    FloatType lon;
    FloatType elevation;
    String name;
    String vault;
    String geology;
    Site site;
    int totalNumChannels;
    int selectedNumChannels;
    String networkCode;
    List<Channel> channelList = new ArrayList<Channel>();
    List<Equipment> equipmentList = new ArrayList<Equipment>();
    List<String> externalReferenceList = new ArrayList<String>();

    public Station(XMLEventReader reader, String networkCode) throws XMLStreamException, StationXMLException {
        this.networkCode = networkCode;
        StartElement startE = StaxUtil.expectStartElement("Station", reader);
        super.parseAttributes(startE);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("Latitude")) {
                    this.lat = new FloatType(reader, "Latitude", "DEGREES");
                    continue;
                }
                if (elName.equals("Longitude")) {
                    this.lon = new FloatType(reader, "Longitude", "DEGREES");
                    continue;
                }
                if (elName.equals("Elevation")) {
                    this.elevation = new FloatType(reader, "Elevation", "METER");
                    continue;
                }
                if (elName.equals("Site")) {
                    this.site = new Site(reader);
                    continue;
                }
                if (elName.equals("Vault")) {
                    this.vault = StaxUtil.pullText(reader, "Vault");
                    continue;
                }
                if (elName.equals("Geology")) {
                    this.geology = StaxUtil.pullText(reader, "Geology");
                    continue;
                }
                if (elName.equals("Equipment")) {
                    this.equipmentList.add(new Equipment(reader));
                    continue;
                }
                if (elName.equals("CreationDate")) {
                    this.creationDate = StaxUtil.pullText(reader, "CreationDate");
                    continue;
                }
                if (elName.equals("TerminationDate")) {
                    this.terminationDate = StaxUtil.pullText(reader, "TerminationDate");
                    continue;
                }
                if (elName.equals("TotalNumberChannels")) {
                    this.totalNumChannels = StaxUtil.pullInt(reader, "TotalNumberChannels");
                    continue;
                }
                if (elName.equals("SelectedNumberChannels")) {
                    this.selectedNumChannels = StaxUtil.pullInt(reader, "SelectedNumberChannels");
                    continue;
                }
                if (elName.equals("ExternalReference")) {
                    this.externalReferenceList.add(StaxUtil.pullText(reader, "ExternalReference"));
                    continue;
                }
                if (elName.equals("Channel")) {
                    this.channelList.add(new Channel(reader, networkCode, this.getCode()));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public FloatType getLatitude() {
        return this.lat;
    }

    public FloatType getLongitude() {
        return this.lon;
    }

    public FloatType getElevation() {
        return this.elevation;
    }

    public String getName() {
        return this.name;
    }

    public Site getSite() {
        return this.site;
    }

    public int getTotalNumChannels() {
        return this.totalNumChannels;
    }

    public int getSelectedNumChannels() {
        return this.selectedNumChannels;
    }

    public List<Channel> getChannelList() {
        return this.channelList;
    }

    public String getTerminationDate() {
        return this.terminationDate;
    }

    public String getVault() {
        return this.vault;
    }

    public String getGeology() {
        return this.geology;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public List<Equipment> getEquipmentList() {
        return this.equipmentList;
    }

    public List<String> getExternalReferenceList() {
        return this.externalReferenceList;
    }

    public String toString() {
        return this.getNetworkCode() + "." + this.getCode();
    }
}

