/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseFilterType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Coefficients;
import edu.sc.seis.seisFile.fdsnws.stationxml.Decimation;
import edu.sc.seis.seisFile.fdsnws.stationxml.FIR;
import edu.sc.seis.seisFile.fdsnws.stationxml.GainSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.PolesZeros;
import edu.sc.seis.seisFile.fdsnws.stationxml.Polynomial;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseList;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ResponseStage {
    private Integer number;
    private String resourceId;
    private BaseFilterType responseItem;
    private Decimation decimation;
    private GainSensitivity stageGain;

    public ResponseStage(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Stage", reader);
        this.number = StaxUtil.pullIntAttribute(startE, "number");
        try {
            this.resourceId = StaxUtil.pullAttribute(startE, "resourceId");
        }
        catch (StationXMLException stationXMLException) {
            // empty catch block
        }
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("PolesZeros")) {
                    this.responseItem = new PolesZeros(reader);
                    continue;
                }
                if (elName.equals("Coefficients")) {
                    this.responseItem = new Coefficients(reader);
                    continue;
                }
                if (elName.equals("ResponseList")) {
                    this.responseItem = new ResponseList(reader);
                    continue;
                }
                if (elName.equals("FIR")) {
                    this.responseItem = new FIR(reader);
                    continue;
                }
                if (elName.equals("Polynomial")) {
                    this.responseItem = new Polynomial(reader);
                    continue;
                }
                if (elName.equals("Decimation")) {
                    this.decimation = new Decimation(reader);
                    continue;
                }
                if (elName.equals("StageGain")) {
                    this.stageGain = new GainSensitivity(reader, "StageGain");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public Integer getNumber() {
        return this.number;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public BaseFilterType getResponseItem() {
        return this.responseItem;
    }

    public Decimation getDecimation() {
        return this.decimation;
    }

    public GainSensitivity getStageSensitivity() {
        return this.stageGain;
    }
}

