/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.quakeml.Quakeml;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FDSNEventQuerier
extends AbstractFDSNQuerier {
    FDSNEventQueryParams queryParams;
    private static Logger logger = LoggerFactory.getLogger(FDSNEventQuerier.class);

    public FDSNEventQuerier(FDSNEventQueryParams queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public URL getSchemaURL() {
        return Quakeml.loadSchema();
    }

    public Quakeml getQuakeML() throws FDSNWSException {
        try {
            this.connect();
            if (!this.isError()) {
                if (!this.isEmpty()) {
                    try {
                        Quakeml quakeml = new Quakeml(this.getReader());
                        if (!quakeml.checkSchemaVersion()) {
                            logger.warn("XmlSchema of this document does not match this code, results may be incorrect. XmlSchema (code): http://quakeml.org/xmlns/quakeml/1.2XmlSchema (doc): " + quakeml.getSchemaVersion());
                        }
                        quakeml.setQuerier(this);
                        quakeml.setResponse(this.response);
                        return quakeml;
                    }
                    catch (XMLStreamException e) {
                        this.handleXmlStreamException(e);
                        throw new RuntimeException("Should not happen");
                    }
                }
                return Quakeml.createEmptyQuakeML();
            }
            throw new FDSNWSException("Error: " + this.getErrorMessage(), this.getConnectionUri(), this.responseCode);
        }
        catch (URISyntaxException e) {
            throw new FDSNWSException("Error with URL syntax", e);
        }
        catch (SeisFileException e) {
            if (e instanceof FDSNWSException) {
                ((FDSNWSException)e).setTargetURI(this.getConnectionUri());
                throw (FDSNWSException)e;
            }
            throw new FDSNWSException(e.getMessage(), e, this.getConnectionUri());
        }
    }

    public void validateQuakeML() throws SeisFileException, URISyntaxException {
        try {
            this.connect();
            if (!this.isError() && !this.isEmpty()) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                XMLStreamReader reader = factory.createXMLStreamReader(this.getConnectionUri().toString(), this.getInputStream());
                FDSNEventQuerier.validateQuakeML(reader);
            }
        }
        catch (SAXException e) {
            throw new FDSNWSException("Unable to validate xml", e, this.getConnectionUri());
        }
        catch (XMLStreamException e) {
            throw new FDSNWSException("Unable to read xml", e, this.getConnectionUri());
        }
        catch (IOException e) {
            throw new FDSNWSException("IOException trying to validate", e, this.getConnectionUri());
        }
    }

    public static void validateQuakeML(XMLStreamReader reader) throws SAXException, IOException {
        FDSNEventQuerier.validate(reader, Quakeml.loadSchema());
    }

    @Override
    public URI formURI() throws URISyntaxException {
        return this.queryParams.formURI();
    }

    @Override
    public void outputRaw(OutputStream out) throws MalformedURLException, IOException, URISyntaxException, FDSNWSException {
        this.connect();
        this.outputRaw(this.getInputStream(), out);
    }
}

