/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.earthworm;

import edu.sc.seis.seisFile.earthworm.EarthwormEscapeOutputStream;
import edu.sc.seis.seisFile.earthworm.EarthwormHeartbeater;
import edu.sc.seis.seisFile.earthworm.EarthwormMessage;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import edu.sc.seis.seisFile.syncFile.SyncFileWriter;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class EarthwormImport {
    InputStream in;
    int BUFFER_SIZE = 8192;

    public EarthwormImport(InputStream in) {
        this.in = in;
    }

    public EarthwormMessage nextMessage() throws IOException {
        byte[] buffer = new byte[this.BUFFER_SIZE];
        int index = 0;
        int nextByte = this.in.read();
        boolean isEscapedByte = false;
        while (nextByte != 2) {
            nextByte = this.in.read();
        }
        nextByte = this.in.read();
        if (nextByte == 27) {
            isEscapedByte = true;
            nextByte = this.in.read();
        }
        while (isEscapedByte || nextByte != 3) {
            buffer[index] = (byte)nextByte;
            ++index;
            isEscapedByte = false;
            nextByte = this.in.read();
            if (nextByte != 27) continue;
            isEscapedByte = true;
            nextByte = this.in.read();
        }
        byte[] tbBuf = new byte[index];
        System.arraycopy(buffer, 0, tbBuf, 0, tbBuf.length);
        return new EarthwormMessage(tbBuf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        ArrayList<String> unknownArgs = new ArrayList<String>();
        String argHost = "localhost";
        int argPort = 19000;
        String argSyncfile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--help")) {
                System.out.println("Usage: java edu.sc.seis.seisFile.earthworm.EarthwormImport [-h host][-p port][--sync syncfile]");
                System.exit(0);
            }
            if (i < args.length - 1) {
                if (args[i].equals("-h")) {
                    argHost = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-p")) {
                    argPort = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("--sync")) {
                    argSyncfile = args[i + 1];
                    ++i;
                    continue;
                }
            }
            unknownArgs.add(args[i]);
        }
        if (unknownArgs.size() != 0) {
            System.out.print("I don't understand: ");
            Iterator i = unknownArgs.iterator();
            while (true) {
                if (!i.hasNext()) {
                    System.out.println();
                    System.out.println("Usage: earthwormImpor [--sync syncfile][-h host][-p port]");
                    return;
                }
                String s = (String)i.next();
                System.out.println(s + " ");
            }
        }
        String host = argHost;
        int port = argPort;
        String syncfile = argSyncfile;
        String heartbeatMessage = "heartbeat";
        int heartbeatSeconds = 10;
        int institution = 2;
        int module = 99;
        HashMap<String, Double> lastStartTimeMap = new HashMap<String, Double>();
        HashMap<String, Double> lastEndTimeMap = new HashMap<String, Double>();
        try {
            Socket s = new Socket(host, port);
            BufferedInputStream in = new BufferedInputStream(s.getInputStream());
            EarthwormEscapeOutputStream outStream = new EarthwormEscapeOutputStream(new BufferedOutputStream(s.getOutputStream()));
            EarthwormHeartbeater heartbeater = new EarthwormHeartbeater(null, 10, "heartbeat", 2, 99);
            heartbeater.setOutStream(outStream);
            heartbeater.heartbeat();
            SyncFileWriter syncWriter = null;
            if (syncfile != null) {
                syncWriter = new SyncFileWriter("ewimport", syncfile);
            }
            EarthwormImport ewImport = new EarthwormImport(in);
            try {
                while (true) {
                    block23: {
                        EarthwormMessage message;
                        block20: {
                            String key;
                            TraceBuf2 traceBuf2;
                            block22: {
                                block21: {
                                    if ((message = ewImport.nextMessage()).getMessageType() != 19) break block20;
                                    traceBuf2 = new TraceBuf2(message.getData());
                                    key = traceBuf2.formatNSLCCodes();
                                    if (!lastEndTimeMap.containsKey(key)) break block21;
                                    if (Math.abs(traceBuf2.getStartTime() - (Double)lastEndTimeMap.get(key)) > 1.0 / traceBuf2.getSampleRate()) {
                                        System.out.println("GAP: " + (traceBuf2.getStartTime() - (Double)lastEndTimeMap.get(key)));
                                        if (syncWriter != null) {
                                            syncWriter.appendLine(new SyncLine(traceBuf2.getNetwork(), traceBuf2.getStation(), traceBuf2.getLocId(), traceBuf2.getChannel(), new Date(Math.round(1000.0 * (Double)lastStartTimeMap.get(key))), new Date(Math.round(1000.0 * (Double)lastEndTimeMap.get(key))), Float.valueOf(0.0f), Float.valueOf(0.0f)));
                                            lastStartTimeMap.put(key, traceBuf2.getStartTime());
                                        }
                                    }
                                    break block22;
                                }
                                lastStartTimeMap.put(key, traceBuf2.getStartTime());
                            }
                            lastEndTimeMap.put(key, traceBuf2.getPredictedNextStartTime());
                            System.out.println("TraceBuf: " + traceBuf2);
                            break block23;
                        }
                        if (message.getMessageType() == 3) {
                            System.out.println("Heartbeat received: " + new String(message.data));
                        }
                    }
                    Thread.sleep(1L);
                }
            }
            catch (IOException e) {
                System.out.println("Remote connection closed.");
                heartbeater.setOutStream(null);
                outStream.close();
                if (syncWriter == null) return;
                Iterator iterator = lastStartTimeMap.keySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        syncWriter.close();
                        return;
                    }
                    String key = (String)iterator.next();
                    String[] chanCodes = key.split("\\.");
                    syncWriter.appendLine(new SyncLine(chanCodes[0], chanCodes[1], chanCodes[2], chanCodes[3], new Date(Math.round(1000.0 * (Double)lastStartTimeMap.get(key))), new Date(Math.round(1000.0 * (Double)lastEndTimeMap.get(key))), Float.valueOf(0.0f), Float.valueOf(0.0f)));
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Unable to bind to '" + host + "' at port " + port, e);
        }
    }
}

