/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.StAXFileWriter;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.XMLParameter;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetToXMLStAX {
    protected boolean saveLocally = true;
    protected boolean useDataSetRef = true;
    static Logger logger = LoggerFactory.getLogger(DataSetToXMLStAX.class);

    public File save(DataSet dataset, File saveDirectory) throws IOException, XMLStreamException {
        String filename = DataSetToXMLStAX.createFileName(dataset);
        logger.debug("save to " + filename + " in " + saveDirectory.toString());
        saveDirectory.mkdirs();
        File outFile = new File(saveDirectory, filename);
        this.createFile(dataset, saveDirectory, outFile);
        logger.debug("Done with save to " + saveDirectory.toString());
        return outFile;
    }

    public static String createFileName(DataSet dataset) {
        String filename = dataset.getName() + ".dsml";
        filename = filename.replaceAll(" ", "_");
        filename = filename.replaceAll(",", "_");
        filename = filename.replaceAll("/", "_");
        filename = filename.replaceAll(":", "_");
        return filename;
    }

    public void createFile(DataSet dataset, File dataDirectory, File outFile) throws IOException, XMLStreamException {
        StAXFileWriter staxWriter = new StAXFileWriter(outFile);
        staxWriter.getStreamWriter().writeStartDocument();
        this.writeDataSetWithNSInfo(staxWriter.getStreamWriter(), dataset, dataDirectory);
        staxWriter.close();
    }

    public void writeDataSet(XMLStreamWriter writer, DataSet dataset, File directory) throws XMLStreamException, IOException {
        writer.writeStartElement("dataset");
        this.insertDSInfo(writer, dataset, directory);
        XMLUtil.writeEndElementWithNewLine(writer);
    }

    public void writeDataSetWithNSInfo(XMLStreamWriter writer, DataSet dataset, File directory) throws XMLStreamException, IOException {
        this.writeDataSetStartElement(writer);
        this.insertDSInfo(writer, dataset, directory);
        writer.writeEndElement();
    }

    public void writeDataSetStartElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("dataset");
        writer.writeAttribute("xmlns:dataset", "http://www.seis.sc.edu/xschema/dataset/2.0");
        writer.writeAttribute("xmlns", "http://www.seis.sc.edu/xschema/dataset/2.0");
        writer.writeAttribute("xsi:schemaLocation", "http://www.seis.sc.edu/xschema/dataset/2.0 http://www.seis.sc.edu/xschema/dataset/2.0/dataset.xsd");
        writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
    }

    public void insertDSInfo(XMLStreamWriter writer, DataSet dataset, File directory) throws XMLStreamException, IOException {
        writer.writeAttribute("datasetid", dataset.getId());
        XMLUtil.writeTextElement(writer, "name", dataset.getName());
        XMLUtil.writeTextElement(writer, "owner", dataset.getOwner());
        String[] childDataSets = dataset.getDataSetNames();
        for (int i = 0; i < childDataSets.length; ++i) {
            String childDirName = DataSetToXMLStAX.createFileName(dataset.getDataSet(childDataSets[i]));
            File childDirectory = new File(directory, childDirName);
            if (!childDirectory.exists()) {
                childDirectory.mkdirs();
            }
            if (this.useDataSetRef) {
                this.writeRef(writer, dataset.getDataSet(childDataSets[i]), childDirectory);
                continue;
            }
            this.writeDataSet(writer, dataset.getDataSet(childDataSets[i]), childDirectory);
        }
    }

    public void writeURLDataSetSeismogram(XMLStreamWriter writer, URLDataSetSeismogram urlDSS, URL base) throws XMLStreamException {
        writer.writeStartElement("urlDataSetSeismogram");
        urlDSS.insertInto(writer, base);
        XMLUtil.writeEndElementWithNewLine(writer);
    }

    public void writeRef(XMLStreamWriter writer, DataSet dataset, File directory) throws XMLStreamException, IOException {
        File dsFile = this.save(dataset, directory);
        this.writeRef(writer, directory.getName() + "/" + dsFile.getName(), dataset.getName());
    }

    public void writeRef(XMLStreamWriter writer, String datasetURL, String linkTitle) throws XMLStreamException {
        writer.writeStartElement("datasetRef");
        writer.writeAttribute("xlink:href", datasetURL);
        writer.writeAttribute("xlink:type", "simple");
        writer.writeAttribute("xlink:title", linkTitle);
        XMLUtil.writeEndElementWithNewLine(writer);
    }

    public void writeParameter(XMLStreamWriter writer, String name, Object parameter) throws XMLStreamException {
        writer.writeStartElement("parameter");
        XMLParameter.insert(writer, name, parameter);
        XMLUtil.writeEndElementWithNewLine(writer);
    }

    public void writeParameter(XMLStreamWriter writer, String name, String typeDef, String typeName, String value) throws XMLStreamException {
        writer.writeStartElement("parameter");
        XMLParameter.insert(writer, name, typeDef, typeName, value);
        XMLUtil.writeEndElementWithNewLine(writer);
    }
}

