/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.time;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.hibernate.PlottableChunk;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class SortTool {
    public static LocalSeismogramImpl[] byLengthAscending(LocalSeismogramImpl[] seis) {
        Arrays.sort(seis, new SeisSizeSorter());
        return seis;
    }

    public static LocalSeismogramImpl[] byBeginTimeAscending(LocalSeismogramImpl[] seis) {
        Arrays.sort(seis, new SeisBeginSorter());
        return seis;
    }

    public static List<PlottableChunk> byBeginTimeAscending(List<PlottableChunk> pc) {
        Collections.sort(pc, new PCBeginSorter());
        return pc;
    }

    public static PlottableChunk[] byBeginTimeAscending(PlottableChunk[] pc) {
        Arrays.sort(pc, new PCBeginSorter());
        return pc;
    }

    public static RequestFilter[] byBeginTimeAscending(RequestFilter[] rf) {
        Arrays.sort(rf, new RFBeginSorter());
        return rf;
    }

    public static MicroSecondTimeRange[] byBeginTimeAscending(MicroSecondTimeRange[] ranges) {
        Arrays.sort(ranges, new MSTRBeginSorter());
        return ranges;
    }

    private static class MSTRBeginSorter
    extends AscendingTimeSorter {
        private MSTRBeginSorter() {
        }

        @Override
        public MicroSecondDate getTime(Object o) {
            return ((MicroSecondTimeRange)o).getBeginTime();
        }
    }

    private static class RFBeginSorter
    extends AscendingTimeSorter {
        private RFBeginSorter() {
        }

        @Override
        public MicroSecondDate getTime(Object o) {
            return new MicroSecondDate(((RequestFilter)o).start_time);
        }
    }

    private static class PCBeginSorter
    extends AscendingTimeSorter {
        private PCBeginSorter() {
        }

        @Override
        public MicroSecondDate getTime(Object o) {
            return ((PlottableChunk)o).getBeginTime();
        }
    }

    private static class SeisBeginSorter
    extends AscendingTimeSorter {
        private SeisBeginSorter() {
        }

        @Override
        public MicroSecondDate getTime(Object o) {
            return ((LocalSeismogramImpl)o).getBeginTime();
        }
    }

    public static class AscendingTimeSorter
    implements Comparator {
        public int compare(Object o1, Object o2) {
            MicroSecondDate o2Begin;
            MicroSecondDate o1Begin = this.getTime(o1);
            if (o1Begin.before((Date)(o2Begin = this.getTime(o2)))) {
                return -1;
            }
            if (o1Begin.after((Date)o2Begin)) {
                return 1;
            }
            return 0;
        }

        public MicroSecondDate getTime(Object o) {
            return (MicroSecondDate)o;
        }
    }

    public static class SeisSizeSorter
    extends AscendingSizeSorter {
        @Override
        public TimeInterval getInterval(Object o) {
            return ((LocalSeismogramImpl)o).getTimeInterval();
        }
    }

    private static class AscendingSizeSorter
    implements Comparator {
        private AscendingSizeSorter() {
        }

        public int compare(Object o1, Object o2) {
            TimeInterval int2;
            TimeInterval int1 = this.getInterval(o1);
            if (int1.lessThan((QuantityImpl)(int2 = this.getInterval(o2)))) {
                return -1;
            }
            if (int1.greaterThan((QuantityImpl)int2)) {
                return 1;
            }
            return 0;
        }

        public TimeInterval getInterval(Object o) {
            return (TimeInterval)o;
        }
    }
}

