/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelIdIterHolder;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkDC;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.IfNetwork.OrientationRange;
import edu.iris.Fissures.IfNetwork.SamplingRange;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.BoxAreaImpl;
import edu.iris.Fissures.model.GlobalAreaImpl;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.OrientationRangeImpl;
import edu.iris.Fissures.network.SamplingRangeImpl;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.TestingClient;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleNetworkClient
implements TestingClient {
    protected Channel testChannel;
    protected Station testStation;
    protected NetworkAccess net;
    protected NetworkDC netDC;
    private static Logger logger = LoggerFactory.getLogger(SimpleNetworkClient.class);

    public SimpleNetworkClient() {
        this("II", "edu/iris/dmc", "IRIS_NetworkDC");
    }

    public SimpleNetworkClient(String networkCode, String serverDNS, String serverName) {
        try {
            Initializer.getNS().getNetworkDCObject(serverDNS, serverName);
            logger.info("Got network as corba object, the name service is ok");
            this.netDC = Initializer.getNS().getNetworkDC(serverDNS, serverName);
            logger.info("got NetworkDC");
            NetworkFinder finder = this.netDC.a_finder();
            logger.info("got NetworkFinder");
            NetworkAccess[] nets = finder.retrieve_by_code(networkCode);
            this.net = nets[0];
            Station[] stations = this.net.retrieve_stations();
            logger.info("Threre are " + stations.length + " stations in " + networkCode);
            this.testStation = stations[0];
            Channel[] channels = this.net.retrieve_for_station(stations[0].get_id());
            logger.info("There are " + channels.length + " channels for " + stations[0].get_code());
            this.testChannel = channels[0];
        }
        catch (NetworkNotFound e) {
            logger.error("Network " + networkCode + " was not found", (Throwable)e);
        }
        catch (InvalidName e) {
            logger.error("Problem with name service: ", (Throwable)e);
        }
        catch (NotFound e) {
            logger.error("Problem with name service: ", (Throwable)e);
        }
        catch (CannotProceed e) {
            logger.error("Problem with name service: ", (Throwable)e);
        }
    }

    @Override
    public void exercise() {
        this.get_attributes(true);
        this.retrieve_stations(true);
        this.locate_channels(true);
        this.explorer_locate_channels(true);
    }

    public NetworkAttr get_attributes() {
        return this.get_attributes(false);
    }

    public NetworkAttr get_attributes(boolean verbose) {
        NetworkAttr attr = this.net.get_attributes();
        if (verbose) {
            logger.info("Network " + attr.get_code() + " retrieved, owner=" + attr.getOwner() + " desc=" + attr.getDescription());
        }
        return attr;
    }

    public Station[] retrieve_stations() {
        return this.retrieve_stations(false);
    }

    public Station[] retrieve_stations(boolean verbose) {
        Station[] stations = this.net.retrieve_stations();
        if (verbose) {
            logger.info("Received " + stations.length + " stations");
            for (int i = 0; i < stations.length; ++i) {
                logger.info(stations[i].get_code() + "  " + stations[i].getName() + " (" + stations[i].getLocation().latitude + ", " + stations[i].getLocation().longitude + ")");
            }
        }
        Channel[] chan = this.net.retrieve_for_station(stations[0].get_id());
        logger.info("retrieve_for_station(" + StationIdUtil.toString((StationId)stations[0].get_id()) + ")");
        return stations;
    }

    public Channel[] locate_channels(boolean verbose) {
        TimeInterval oneSecond = new TimeInterval(1.0, UnitImpl.SECOND);
        SamplingImpl minSample = new SamplingImpl(1, oneSecond);
        SamplingImpl maxSample = new SamplingImpl(100, oneSecond);
        SamplingRangeImpl sampleRange = new SamplingRangeImpl((Sampling)minSample, (Sampling)maxSample);
        Orientation orient = new Orientation(0.0f, -90.0f);
        QuantityImpl angle = new QuantityImpl(45.0, (Unit)UnitImpl.DEGREE);
        OrientationRangeImpl orientationRange = new OrientationRangeImpl(orient, (Quantity)angle);
        GlobalAreaImpl area = new GlobalAreaImpl();
        area = new BoxAreaImpl(0.0f, 90.0f, 0.0f, 90.0f);
        Channel[] chans = this.net.locate_channels((Area)area, (SamplingRange)sampleRange, (OrientationRange)orientationRange);
        if (verbose) {
            logger.info("Received " + chans.length + " channels by location");
        }
        return chans;
    }

    public ChannelId[] explorer_locate_channels(boolean verbose) {
        TimeInterval oneSecond = new TimeInterval(1.0, UnitImpl.SECOND);
        SamplingImpl minSample = new SamplingImpl(1, oneSecond);
        SamplingImpl maxSample = new SamplingImpl(100, oneSecond);
        SamplingRangeImpl sampleRange = new SamplingRangeImpl((Sampling)minSample, (Sampling)maxSample);
        Orientation orient = new Orientation(0.0f, -90.0f);
        QuantityImpl angle = new QuantityImpl(45.0, (Unit)UnitImpl.DEGREE);
        OrientationRangeImpl orientationRange = new OrientationRangeImpl(orient, (Quantity)angle);
        GlobalAreaImpl area = new GlobalAreaImpl();
        area = new BoxAreaImpl(0.0f, 90.0f, -130.0f, -90.0f);
        ChannelId[] chans = this.netDC.a_explorer().locate_channels((Area)area, (SamplingRange)sampleRange, (OrientationRange)orientationRange, 1000, new ChannelIdIterHolder());
        if (verbose) {
            logger.info("Received " + chans.length + " channels by explorer.locate_channels");
        }
        return chans;
    }

    public static void main(String[] args) {
        Initializer.init(args);
        new SimpleNetworkClient().exercise();
    }
}

