/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.netConnChecker;

import edu.sc.seis.fissuresUtil.netConnChecker.ConnChecker;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatus;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatusChangedListener;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatusResult;
import edu.sc.seis.fissuresUtil.netConnChecker.StatusChangedEvent;
import java.util.Vector;

public abstract class ConcreteConnChecker
implements ConnChecker {
    private String description;
    protected String reason = "";
    protected Throwable cause = null;
    private boolean successful = false;
    private boolean unknown = false;
    private boolean trying = true;
    private boolean finished = false;
    private Vector statusChangeListeners = new Vector();

    public ConcreteConnChecker(String description) {
        this.description = description;
    }

    public void setFinished(boolean value) {
        this.finished = value;
    }

    public void setSuccessful(boolean value) {
        this.successful = value;
    }

    public void setUnknown(boolean value) {
        this.unknown = value;
    }

    public void setTrying(boolean value) {
        this.trying = value;
    }

    @Override
    public ConnStatusResult getStatus() {
        if (this.successful) {
            return new ConnStatusResult(ConnStatus.SUCCESSFUL);
        }
        if (this.unknown) {
            return new ConnStatusResult(ConnStatus.UNKNOWN);
        }
        if (this.trying) {
            return new ConnStatusResult(ConnStatus.TRYING);
        }
        return new ConnStatusResult(ConnStatus.FAILED, this.reason, this.cause);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public void addConnStatusChangedListener(ConnStatusChangedListener listener) {
        this.statusChangeListeners.add(listener);
    }

    @Override
    public void removeConnStatusChangedListener(ConnStatusChangedListener listener) {
        this.statusChangeListeners.remove(listener);
    }

    @Override
    public synchronized void fireStatusChanged(String urlStr, ConnStatus connectionStatus) {
        ConnStatusResult result = new ConnStatusResult(connectionStatus, this.reason, this.cause);
        for (int counter = 0; counter < this.statusChangeListeners.size(); ++counter) {
            ConnStatusChangedListener listener = (ConnStatusChangedListener)this.statusChangeListeners.elementAt(counter);
            listener.statusChanged(new StatusChangedEvent(this, urlStr, result));
        }
    }
}

