/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mseed;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.mseed.FissuresConvert;
import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class MSeedFileRead {
    public static void main(String[] args) throws IOException, SeedFormatException {
        InputStream inStream;
        String network = null;
        String station = null;
        String location = null;
        String channel = null;
        String filename = null;
        String outFile = null;
        int maxRecords = -1;
        int defaultRecordSize = 4096;
        boolean verbose = false;
        boolean dumpData = false;
        FilterOutputStream dos = null;
        PrintWriter out = new PrintWriter(System.out, true);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-n")) {
                network = args[i + 1];
                continue;
            }
            if (args[i].equals("-s")) {
                station = args[i + 1];
                continue;
            }
            if (args[i].equals("-l")) {
                location = args[i + 1];
                continue;
            }
            if (args[i].equals("-c")) {
                channel = args[i + 1];
                continue;
            }
            if (args[i].equals("-d")) {
                dumpData = true;
                continue;
            }
            if (args[i].equals("-o")) {
                outFile = args[i + 1];
                dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
                continue;
            }
            if (args[i].equals("-r")) {
                defaultRecordSize = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-m")) {
                maxRecords = Integer.parseInt(args[i + 1]);
                if (maxRecords >= -1) continue;
                maxRecords = -1;
                continue;
            }
            if (args[i].equals("--verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("--version")) {
                out.println(BuildVersion.getDetailedVersion());
                System.exit(0);
                continue;
            }
            if (args[i].equals("--help")) {
                out.println("java " + MSeedFileRead.class.getName() + " [-n net][-s sta][-l loc][-c chan][-o mseedOutfile][-m maxrecords][--verbose][--version][--help] <filename>");
                System.exit(0);
                continue;
            }
            filename = args[i];
        }
        if (filename == null) {
            return;
        }
        File f = new File(filename);
        if (f.exists() && f.isFile()) {
            inStream = new FileInputStream(filename);
        } else {
            try {
                URL url = new URL(filename);
                inStream = url.openStream();
            }
            catch (MalformedURLException e) {
                out.println("Cannot load '" + filename + "', as file or URL: exists=" + f.exists() + " isFile=" + f.isFile() + " " + e.getMessage());
                return;
            }
            catch (FileNotFoundException e) {
                out.println("Cannot load '" + filename + "', as file or URL: exists=" + f.exists() + " isFile=" + f.isFile() + " " + e.getMessage());
                return;
            }
        }
        DataInputStream dataInStream = new DataInputStream(new BufferedInputStream(inStream, 1024));
        try {
            for (int i = 0; maxRecords == -1 || i < maxRecords; ++i) {
                SeedRecord sr = SeedRecord.read((DataInput)dataInStream, (int)defaultRecordSize);
                if (sr instanceof DataRecord) {
                    DataRecord dr = (DataRecord)sr;
                    if (network != null && !network.equals(dr.getHeader().getNetworkCode()) || station != null && !station.equals(dr.getHeader().getStationIdentifier()) || location != null && !location.equals(dr.getHeader().getLocationIdentifier()) || channel != null && !channel.equals(dr.getHeader().getChannelIdentifier())) continue;
                    if (dos != null) {
                        dr.write((DataOutputStream)dos);
                    }
                    if (dos == null || verbose) {
                        dr.writeASCII(out, "    ");
                        out.flush();
                    }
                    if (dumpData) {
                        dr.writeData(out);
                    }
                    LocalSeismogramImpl seis = FissuresConvert.toFissures(dr);
                    try {
                        int[] data = seis.get_as_longs();
                        System.out.println("Decompress to " + data.length);
                        continue;
                    }
                    catch (FissuresException e) {
                        throw new RuntimeException(dr.toString(), e);
                    }
                }
                sr.writeASCII(out, "    ");
                out.flush();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (dos != null) {
            dos.close();
        }
        dataInStream.close();
        out.println("Finished: " + new Date());
    }
}

